<?php if ($_SESSION['Acceso'] !== 'AccesoSiqueSi') die(); ?>
<div class="card mb-3 shadow-sm border-0">
    <div class="card-body p-3">
        <label class="text-muted small font-weight-bold">CLIENTE ASIGNADO</label>
        <div class="input-group">
            <div class="input-group-prepend">
                <span class="input-group-text bg-white"><i class="feather icon-user"></i></span>
            </div>
            <select id="selClienteGlobal" class="form-control border-left-0">
                <option value="1">Público General</option>
            </select>
            <div class="input-group-append">
                <button class="btn btn-outline-primary" type="button" data-toggle="modal" data-target="#modalNuevoCliente">
                    <i class="feather icon-user-plus"></i>
                </button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalNuevoCliente" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Nuevo Cliente</h5>
                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Nombre Completo</label>
                    <input type="text" id="reg_nom" class="form-control" placeholder="Ej. Juan Pérez">
                </div>
                <div class="form-group">
                    <label>Teléfono</label>
                    <input type="number" id="reg_tel" class="form-control" placeholder="10 dígitos">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary btn-block shadow" onclick="fn_GuardarCliente()">Guardar y Seleccionar</button>
            </div>
        </div>
    </div>
</div>

<script>
// Carga inicial de clientes usando tu API
function fn_CargarClientes() {
    const sql = "SELECT IDC, Nombre, Telefono FROM `1-Clientes` WHERE EstadoCliente = 'Activo'";
    fetch('../librerias/AJAX/Select.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=MS_Datos`
    })
    .then(r => r.json())
    .then(res => {
        const sel = document.getElementById('selClienteGlobal');
        sel.innerHTML = '';
        res.data.forEach(c => {
            const opt = document.createElement('option');
            opt.value = c.IDC;
            opt.text = `${c.Nombre} (${c.Telefono || 'S/N'})`;
            sel.appendChild(opt);
        });
    });
}

function fn_GuardarCliente() {
    const n = document.getElementById('reg_nom').value;
    const t = document.getElementById('reg_tel').value;
    if(!n || !t) return alert("Campos obligatorios");

    const idu = 'CLI-' + Date.now();
    const sql = `INSERT INTO \`1-Clientes\` (Nombre, Telefono, IDU, EstadoCliente) VALUES ('${n}', '${t}', '${idu}', 'Activo')`;
    
    fetch('../librerias/AJAX/Execute.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=MS_Datos`
    })
    .then(r => r.json())
    .then(res => {
        if(res.last_id) {
            $('#modalNuevoCliente').modal('hide');
            fn_CargarClientes(); // Recarga y selecciona
            alert("Cliente agregado con éxito");
        }
    });
}
fn_CargarClientes(); // Auto-ejecución al cargar módulo
</script>