<?php
// PDFGenerador.php - Versión Final Blindada con Selección de Módulo
ini_set('display_errors', 0);
require_once('../Conexion.php'); 
require_once('fpdf/fpdf.php');

$idDoc = $_GET['id'] ?? null;
$idu   = $_GET['idu'] ?? null;

if (!$idDoc || !$idu) die("Error: Faltan parámetros ID o IDU.");

try {
    $db = new Conexion("MS_Datos");
    $tDocs = "`{$idu}-Documentos_Generados`";
    $tConf = "`{$idu}-Configuracion_Impresoras`";

    $sql = "SELECT d.*, c.* FROM $tDocs d 
            INNER JOIN $tConf c ON d.ID_Config_Impresora = c.ID_Config 
            WHERE d.ID_Doc = '$idDoc'";

    $res = $db->obtenerDatos($sql);
    if ($res['status'] == 'error' || empty($res['data'])) throw new Exception("Error al consultar BD.");

    $conf = $res['data'][0];
    $datos = json_decode($conf['Contenido_JSON'], true);
    
    // --- NUEVA LÓGICA DE SELECCIÓN DE MÓDULO ---
    $modulo = $conf['Modulo_Origen'] ?? 'NotaVenta';
	
	if ($modulo === 'OrdenServicio') {
        require_once('ImprimirOS.php');
        $clasePDF = 'PDF_OS';
    } elseif ($modulo === 'Pedidos') { // <-- AGREGAMOS ESTO
        require_once('ImprimirPE.php');
        $clasePDF = 'PDF_Pedido';
    } 
	
	elseif($modulo === 'AquaPOS') {
        require_once('ImpresoraAqua.php'); 
        $clasePDF = 'PDF_Documento';
    } 
	 
	elseif ($modulo === 'Comandera') { // <-- AGREGAMOS ESTO
        require_once('ImprimirCMD.php');
        $clasePDF = 'PDF_Comanda';
    } 
	
	else {
        require_once('ImprimirNV.php');
        $clasePDF = 'PDF_Documento';
    }
    // -------------------------------------------

    $tipoPapelRaw = strtoupper(trim($conf['Tipo_Papel'] ?? '80MM'));
    $esTicket = ($tipoPapelRaw == '58MM' || $tipoPapelRaw == '80MM');

    if (ob_get_level()) ob_end_clean();

    if ($esTicket) {
        $ancho = ($tipoPapelRaw == '58MM') ? 58 : 80;
        // Medición con la clase seleccionada dinámicamente
        $pdfMedir = new $clasePDF('P', 'mm', array($ancho, 1500));
        $pdfMedir->idu = $idu; 
        $pdfMedir->AddPage();
        $alturaExacta = $pdfMedir->disenoTicket($datos, $conf, $ancho);
        $pdfMedir->Close();
        
        // Impresión Real
        $pdf = new $clasePDF('P', 'mm', array($ancho, $alturaExacta + 2));
    } else {
        $orientacion = (strtoupper(trim($conf['Orientacion'])) == 'LANDSCAPE') ? 'L' : 'P';
        $pdf = new $clasePDF($orientacion, 'mm', $tipoPapelRaw);
    }

    $pdf->idu = $idu; 
    $pdf->AddPage();
    $pdf->generarContenido($datos, $conf, $pdf->GetPageWidth());

    header('Content-Type: application/pdf');
    $pdf->Output('I', "{$modulo}_{$idDoc}.pdf");

} catch (Exception $e) {
    echo "Error Crítico: " . $e->getMessage();
}