<?php
// ImprimirCMD.php - Versión Ultra-Compacta para Ahorro de Papel
// Basado en: p (cantidad), name (nombre), note (comentario)

class PDF_Comanda extends FPDF {
    public $idu;

    public function generarContenido($datos, $conf, $ancho) {
        // Desactivar salto automático para evitar la segunda hoja en blanco
        $this->SetAutoPageBreak(false); 
        $this->disenoTicket($datos, $conf, $ancho);
    }

    public function disenoTicket($datos, $conf, $ancho) {
        $margin = ($ancho < 60) ? 2 : 4;
        $this->SetMargins($margin, 2, $margin);
        $utilW = $ancho - ($margin * 2);

        // --- 1. CABECERA COMPACTA ---
        $this->SetFont('Arial', 'B', 9);
        $this->Cell($utilW, 4, utf8_decode(strtoupper($conf['Nombre_Perfil'] ?? 'COMANDA')), 0, 1, 'C');
        
        // --- 2. MESA (Resaltado más bajo para ahorrar) ---
        $this->SetFillColor(0); $this->SetTextColor(255);
        $this->SetFont('Arial', 'B', ($ancho < 60 ? 16 : 19));
        $this->Cell($utilW, 10, utf8_decode($datos['mesa'] ?? 'MESA S/N'), 0, 1, 'C', true);
        
        $this->SetTextColor(0);
        $this->Ln(1);

        // --- 3. DATOS EN UNA SOLA LÍNEA (Economía de espacio) ---
        $this->SetFont('Arial', 'B', 8);
        $mesero = "MESERO: " . ($datos['mesero'] ?? '1');
        $folio = "FOL: " . ($conf['UUID_Unico'] ?? 'N/A');
        $this->Cell($utilW, 4, utf8_decode($mesero . " | " . $folio), 0, 1, 'C');
        
        $this->SetFont('Arial', '', 7);
        $this->Cell($utilW, 4, "FECHA: " . date('d/m/Y H:i'), 'B', 1, 'C');
        $this->Ln(1);

        // --- 4. LISTADO DE PRODUCTOS (Sin encabezados de tabla para ahorrar) ---
        $totalArticulos = 0;
        foreach ($datos['items'] ?? [] as $it) {
            $cant = $it['p'] ?? 1;
            $totalArticulos += $cant;

            $this->SetFont('Arial', 'B', 12);
            // Cantidad y Nombre en la misma línea
            $this->Cell(8, 6, $cant, 0, 0, 'L'); 
            
            $xPos = $this->GetX();
            $this->MultiCell($utilW - 8, 6, utf8_decode(strtoupper($it['name'] ?? '')), 0, 'L');
            
            // Notas del item (solo si existen)
            if (!empty($it['note'])) {
                $this->SetFont('Arial', 'I', 9);
                $this->SetX($xPos);
                $this->MultiCell($utilW - 8, 4, ">> " . utf8_decode($it['note']), 0, 'L');
            }
            // Espacio mínimo entre productos
            $this->SetX($margin);
            $this->Cell($utilW, 0.5, "", 'B', 1); 
        }

        // --- 5. TOTAL Y NOTA FINAL ---
        $this->Ln(1);
        $this->SetFont('Arial', 'B', 9);
        $this->Cell($utilW, 5, "ITEMS: " . $totalArticulos, 0, 1, 'R');

        if (!empty($datos['nota'])) {
            $this->SetFont('Arial', 'I', 8);
            $this->MultiCell($utilW, 4, "NOTA: " . utf8_decode($datos['nota']), 0, 'L');
        }

        $this->SetFont('Arial', '', 6);
        $this->Cell($utilW, 4, "*** FIN DE ORDEN ***", 0, 1, 'C');

        // Retorna la posición Y final exacta
        return $this->GetY();
    }
}