<?php
// reboot.php
// Un solo archivo: PHP + Bootstrap que permite pedir reboot al servidor con confirmación y contraseña.
//
// CONFIGURACIÓN (edita estas variables al principio):
session_start();
$ADMIN_PASS_HASH = '33comRxXSys'; // <-- Reemplaza por el hash generado más abajo
$LOG_FILE = '/var/log/web_reboot.log';   // archivo donde registramos intentos (asegúrate de permisos)
// Ruta al comando reboot (ajusta si es necesario)
$REBOOT_CMD = '/sbin/reboot';

// Cómo generar el hash (en consola, reemplaza "MiPasswordFuerte"):
// php -r "echo password_hash('MiPasswordFuerte', PASSWORD_DEFAULT) . PHP_EOL;"
// Copia el resultado y pégalo en $ADMIN_PASS_HASH arriba.

// Seguridad adicional recomendada:
// 1) Usar HTTPS.
// 2) Limitar acceso (IP whitelist / autenticación HTTP / intranet).
// 3) Dar permiso sudo solo al binario reboot al usuario webserver:
//    EDITA con visudo: www-data ALL=(ALL) NOPASSWD: /sbin/reboot

// -- END CONFIG --

// helpers
function generate_csrf() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}
function verify_csrf($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}
function log_action($msg) {
    global $LOG_FILE;
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $line = sprintf("[%s] %s - %s\n", date('Y-m-d H:i:s'), $ip, $msg);
    @file_put_contents($LOG_FILE, $line, FILE_APPEND | LOCK_EX);
}

// Manejo del POST (intentona de reinicio)
$feedback = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    $pass  = $_POST['admin_password'] ?? '';

    if (!verify_csrf($token)) {
        $feedback = 'Token inválido. Intenta recargar la página.';
        log_action("CSRF_FAIL");
    } else {
        if (empty($ADMIN_PASS_HASH) || $ADMIN_PASS_HASH === 'REPLACE_WITH_HASH') {
            $feedback = 'Error de configuración: no se ha establecido $ADMIN_PASS_HASH en el script.';
            log_action("CONFIG_MISSING_HASH");
        } else {
            if (password_verify($pass, $ADMIN_PASS_HASH)) {
                // Ejecutar reboot (usando sudo)
                // Nota: el servidor web debe tener permiso sudo para $REBOOT_CMD sin contraseña.
                $cmd = 'sudo ' . escapeshellcmd($REBOOT_CMD) . ' 2>&1';
                log_action("REBOOT_AUTH_OK: ejecutando comando: $REBOOT_CMD");
                // Ejecutamos el comando y retornamos la salida (si la hubiera)
                // En muchos sistemas el comando provoca que la conexión se corte inmediatamente.
                $output = [];
                $return_var = null;
                @exec($cmd, $output, $return_var);
                // registrar salida
                log_action("REBOOT_CMD_EXITCODE={$return_var} OUTPUT=" . substr(implode("\n", $output), 0, 1000));
                // Dar feedback al usuario
                $feedback = 'Comando de reinicio enviado. El servidor debería reiniciarse en breve.';
            } else {
                $feedback = 'Contraseña incorrecta.';
                log_action("AUTH_FAIL");
            }
        }
    }
}

// Generar token CSRF para el formulario
$csrf = generate_csrf();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Reboot remoto (seguro)</title>
  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-8 col-lg-6">
        <div class="card shadow-sm">
          <div class="card-body">
            <h3 class="card-title mb-3">Reiniciar servidor</h3>
            <p class="card-text">
              Usa este formulario para enviar un comando de reinicio al servidor.
              <strong>Recomendado:</strong> ejecuta esto solo desde una red segura y con HTTPS.
            </p>

            <?php if ($feedback): ?>
              <div class="alert alert-info" role="alert">
                <?php echo htmlspecialchars($feedback); ?>
              </div>
            <?php endif; ?>

            <div class="mb-3">
              <button id="btnReboot" class="btn btn-danger w-100" data-bs-toggle="modal" data-bs-target="#confirmModal">
                Reiniciar servidor ahora
              </button>
            </div>

            <small class="text-muted">
              Acción registrada en: <?php echo htmlspecialchars($LOG_FILE); ?>
            </small>
          </div>
        </div>

        <p class="text-muted text-center mt-3 small">
          Asegúrate de tener configurado sudo correctamente y permisos de archivo para registrar eventos.
        </p>
      </div>
    </div>
  </div>

  <!-- Modal de confirmación -->
  <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <form method="post" class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmModalLabel">Confirmar reinicio</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <p>¿Estás seguro de que deseas reiniciar el servidor? Esta acción desconectará todos los servicios.</p>

          <div class="mb-3">
            <label for="admin_password" class="form-label">Contraseña de administrador</label>
            <input type="password" class="form-control" id="admin_password" name="admin_password" required autocomplete="off">
            <div class="form-text">Introduce la contraseña administrativa para autorizar el reinicio.</div>
          </div>

          <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf); ?>">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-danger">Confirmar reinicio</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Bootstrap JS (popper incluido) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
