<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generador de Tablas SQL + JSON</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">

    <style>
        body { background: #f8f9fa; }
        .column-card {
            border-left: 4px solid #0d6efd;
            padding: 15px;
            background: white;
            margin-bottom: 10px;
            border-radius: 8px;
        }
    </style>
</head>
<body>

<div class="container py-4">
    <h2 class="mb-4">Generador de Tablas SQL + JSON</h2>

    <!-- Nombre de tabla -->
    <div class="mb-3">
        <label class="form-label">Nombre de la Tabla</label>
        <input type="text" id="tableName" class="form-control" placeholder="ej: usuarios">
    </div>

    <h4 class="mt-4">Columnas</h4>

    <div id="columns"></div>

    <button class="btn btn-primary mt-3" onclick="addColumn()">Agregar Columna</button>

    <hr>

    <button class="btn btn-success" onclick="generateSQL()">Generar SQL</button>
    <button class="btn btn-dark" onclick="generateJSON()">Generar JSON</button>

    <h4 class="mt-4">Resultado SQL</h4>
    <textarea id="resultSQL" class="form-control" rows="8"></textarea>

    <h4 class="mt-4">Resultado JSON</h4>
    <textarea id="resultJSON" class="form-control" rows="10"></textarea>

</div>

<script>
    let columnCount = 0;

    function addColumn() {
        columnCount++;

        const html = `
        <div class="column-card" id="col-${columnCount}">
            <div class="row">
                <div class="col-md-3">
                    <label>Nombre</label>
                    <input type="text" class="form-control col-name" placeholder="ej: nombre">
                </div>

                <div class="col-md-3">
                    <label>Tipo</label>
                    <select class="form-control col-type" onchange="toggleLength(this)">
                        <option value="INT">INT</option>
                        <option value="VARCHAR">VARCHAR</option>
                        <option value="TEXT">TEXT</option>
                        <option value="JSON">JSON</option>
                        <option value="TIMESTAMP">TIMESTAMP</option>
                        <option value="DATE">DATE</option>
                        <option value="FLOAT">FLOAT</option>
                        <option value="DOUBLE">DOUBLE</option>
                        <option value="BOOLEAN">BOOLEAN</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label>Longitud</label>
                    <input type="number" class="form-control col-length" placeholder="255" disabled>
                </div>

                <div class="col-md-2">
                    <label>Opciones</label>
                    <select class="form-control col-extra">
                        <option value="">Ninguna</option>
                        <option value="NOT NULL">NOT NULL</option>
                        <option value="NULL">NULL</option>
                        <option value="AUTO_INCREMENT">AUTO_INCREMENT</option>
                        <option value="UNIQUE">UNIQUE</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label>Acciones</label><br>
                    <button class="btn btn-danger btn-sm" onclick="removeColumn(${columnCount})">Eliminar</button>
                </div>
            </div>
        </div>
        `;

        document.getElementById("columns").insertAdjacentHTML("beforeend", html);
    }

    function toggleLength(select) {
        const lengthInput = select.closest(".row").querySelector(".col-length");
        if (select.value === "VARCHAR") {
            lengthInput.disabled = false;
        } else {
            lengthInput.disabled = true;
            lengthInput.value = "";
        }
    }

    function removeColumn(id) {
        const col = document.getElementById("col-" + id);
        if (col) col.remove();
    }

    function generateSQL() {
        const tableName = document.getElementById("tableName").value.trim();
        if (!tableName) {
            alert("Debes ingresar un nombre de tabla");
            return;
        }

        let sql = `CREATE TABLE ${tableName} (\n`;

        const columns = document.querySelectorAll(".column-card");

        columns.forEach((col, i) => {
            const name = col.querySelector(".col-name").value.trim();
            const type = col.querySelector(".col-type").value;
            const length = col.querySelector(".col-length").value;
            const extra = col.querySelector(".col-extra").value;

            if (!name) return;

            let line = `  ${name} ${type}`;
            if (length) line += `(${length})`;
            if (extra) line += ` ${extra}`;

            if (i < columns.length - 1) line += ",";

            sql += line + "\n";
        });

        sql += ");";

        document.getElementById("resultSQL").value = sql;
    }

    function generateJSON() {
        const tableName = document.getElementById("tableName").value.trim();
        if (!tableName) {
            alert("Debes ingresar un nombre de tabla");
            return;
        }

        const columnsData = [];
        const columns = document.querySelectorAll(".column-card");

        columns.forEach((col) => {
            const name = col.querySelector(".col-name").value.trim();
            const type = col.querySelector(".col-type").value;
            const length = col.querySelector(".col-length").value;
            const extra = col.querySelector(".col-extra").value;

            if (!name) return;

            columnsData.push({
                name: name,
                type: type,
                length: length ? Number(length) : null,
                extra: extra || ""
            });
        });

        const jsonOutput = {
            table: tableName,
            columns: columnsData
        };

        document.getElementById("resultJSON").value = JSON.stringify(jsonOutput, null, 4);
    }
</script>

</body>
</html>
