<?php
header("Content-Type: application/json");

// Recibir JSON desde JS
$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data["passwordCliente"])) {
    echo json_encode(["mensaje" => "Error: No se recibió la contraseña"]);
    exit;
}

$hashCliente = trim($data["passwordCliente"]);

// Volver a encriptar de forma segura usando password_hash
$passHash = password_hash($hashCliente, PASSWORD_DEFAULT);


echo json_encode([
    "mensaje" => "Contraseña guardada exitosamente",
    "hash_guardado" => $passHash
]);
