<?php
/**
 * MÓDULO: Visualizador de Páginas WebBuilder 2026
 * Ruta: /v/view.php?id=USER_ID&t=TOKEN
 */
require_once "../librerias/Conexion.php";

// 1. CONFIGURACIÓN DE ACCESO
$db_name = "MS_Datos";
$db = new Conexion($db_name);

// 2. CAPTURA DE IDENTIDAD (IDU + Token)
$idu   = $_GET['id'] ?? ''; 
$token = $_GET['t']  ?? '';

if (empty($idu) || empty($token)) {
    die("<div style='text-align:center; padding:50px; font-family:sans-serif;'>
            <h2>🚀 Enlace no válido</h2>
            <p>Faltan parámetros de identidad.</p>
         </div>");
}

// 3. CONSULTA SEGURA
// Buscamos en la tabla de WebPaginas que configuramos anteriormente
$sql = "SELECT * FROM `1-WebPaginas` 
        WHERE IDU = '$idu' 
        AND Token = '$token' 
        LIMIT 1";

$res = $db->obtenerDatos($sql);
$data = $res['data'][0] ?? null;

if (!$data) {
    die("<div style='text-align:center; padding:50px; font-family:sans-serif;'>
            <h2>🌑 Página no encontrada</h2>
            <p>Es posible que el enlace haya expirado o sea incorrecto.</p>
         </div>");
}

// 4. DECODIFICACIÓN DE CONFIGURACIÓN (Accent Color, Fonts, etc.)
$config = json_decode($data['Config'], true) ?? [];
$accent = $config['accent'] ?? '#4f46e5';
$font   = $config['font']   ?? 'Inter, sans-serif';
$html   = $data['HTML']; // El código que diseñaste en el editor
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $data['Nombre']; ?> | WebBuilder Studio</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&family=Playfair+Display:wght@700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        /* Inyección de Configuración Dinámica */
        :root {
            --primary: <?php echo $accent; ?>;
            --primary-rgb: <?php echo hexToRgb($accent); ?>;
        }

        body {
            font-family: <?php echo $font; ?>;
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
        }

        /* Clases de utilidad para el color de acento dinámico */
        .text-accent { color: var(--primary) !important; }
        .bg-accent { background-color: var(--primary) !important; }
        .border-accent { border-color: var(--primary) !important; }
        
        /* Estilo para la barra de scroll */
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: var(--primary); border-radius: 10px; }

        /* Animaciones para los componentes cargados */
        .fade-in { animation: fadeIn 0.8s ease-out forwards; }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body class="bg-white">

    <main class="fade-in">
        <?php echo $html; ?>
    </main>

    <footer class="py-8 text-center opacity-30 hover:opacity-100 transition-opacity">
        <a href="#" style="text-decoration: none; color: inherit;">
            <small class="font-bold tracking-widest uppercase" style="font-size: 9px;">
                Powered by WebBuilder Studio 2026
            </small>
        </a>
    </footer>

    <?php
    // Función auxiliar para convertir Hex a RGB (útil para transparencias si las necesitas)
    function hexToRgb($hex) {
        $hex = str_replace("#", "", $hex);
        if(strlen($hex) == 3) {
            $r = hexdec(substr($hex,0,1).substr($hex,0,1));
            $g = hexdec(substr($hex,1,1).substr($hex,1,1));
            $b = hexdec(substr($hex,2,1).substr($hex,2,1));
        } else {
            $r = hexdec(substr($hex,0,2));
            $g = hexdec(substr($hex,2,2));
            $b = hexdec(substr($hex,4,2));
        }
        return "$r, $g, $b";
    }
    ?>

</body>
</html>