<li class="header-notification" id="notificaciones-widget">
    <div class="dropdown-primary dropdown">
        <div class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
            <i class="feather icon-bell"></i>
            <span class="badge bg-c-red" id="notif-count" style="display:none;">0</span>
        </div>
        <ul class="show-notification notification-view dropdown-menu" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut">
            <li>
                <h6>Notificaciones</h6>
                <label class="label label-danger">Recientes</label>
            </li>
            
            <div id="notif-list-container">
                <li style="text-align:center; padding: 10px; color: #888;">
                    <i class="fa fa-spinner fa-spin"></i> Cargando...
                </li>
            </div>
            
            <li style="text-align:center; padding: 8px; background: #f4f7fa;">
                 <a href="?A=MisNotificaciones" style="font-size: 12px; font-weight: 600;">Ver todas</a>
            </li>
        </ul>
    </div>
</li>

<script>
(function() {
    /**
     * CONFIGURACIÓN
     * Ajustamos a la nueva tabla MS_Usuario.Notificaciones
     */
    const ID_USUARIO = <?php echo isset($_SESSION['IDU']) ? (int)$_SESSION['IDU'] : 0; ?>;
    const DB_NAME    = 'MS_Usuario'; // Base de datos definida en tu CREATE TABLE

    // Inicialización
    document.addEventListener("DOMContentLoaded", function() {
        if(ID_USUARIO > 0) {
            cargarNotificaciones();
            // Polling: Actualizar cada 60 segundos
            setInterval(cargarNotificaciones, 60000); 
        }
    });

    function cargarNotificaciones() {
        // SQL ajustado a tus nuevos campos: IDU y TimeStamp
        const sql = `SELECT ID, IDU, Nombre_Remitente, Mensaje, Leido, Avatar, TimeStamp, Datos 
                     FROM Notificaciones 
                     WHERE IDU = ${ID_USUARIO} 
                     ORDER BY TimeStamp DESC LIMIT 5`;

        let formData = new FormData();
        formData.append('sql', sql);
        formData.append('db', DB_NAME);

        fetch('../librerias/AJAX/Select.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(res => {
            if (res.status === 'success' || (res.data && Array.isArray(res.data))) {
                renderizarWidget(res.data);
            }
        })
        .catch(err => console.error('Error Notif:', err));
    }

    function renderizarWidget(data) {
        const container = document.getElementById('notif-list-container');
        const badge = document.getElementById('notif-count');
        let html = '';
        let sinLeer = 0;

        if (!data || data.length === 0) {
            container.innerHTML = '<li style="text-align:center; padding:15px;">No tienes notificaciones</li>';
            badge.style.display = 'none';
            return;
        }

        data.forEach(item => {
            // Contar no leídas
            if (item.Leido == 0) sinLeer++;

            // Calcular tiempo relativo usando el campo TimeStamp
            let tiempoTexto = calcularTiempo(item.TimeStamp);
            
            // Determinar estilo si no está leída (negrita o fondo diferente)
            let estiloNoLeido = (item.Leido == 0) ? 'font-weight: bold; background-color: #f0f8ff;' : '';

            /* * Nota sobre el campo 'Datos' (JSON):
             * Podrías usarlo aquí. Ejemplo: let infoExtra = JSON.parse(item.Datos);
             * y usar infoExtra.url para redirigir al usuario.
             */

            html += `
            <li class="notification-item" style="cursor:pointer; ${estiloNoLeido}" onclick="marcarYVer(${item.ID})">
                <div class="media">
                    <img class="img-radius" src="../librerias/Vendor/jpg/${item.Avatar || 'avatar-1.jpg'}" alt="User">
                    <div class="media-body">
                        <h5 class="notification-user">${item.Nombre_Remitente}</h5>
                        <p class="notification-msg">${item.Mensaje}</p>
                        <span class="notification-time" style="font-size:11px;">${tiempoTexto}</span>
                    </div>
                </div>
            </li>`;
        });

        container.innerHTML = html;
        badge.innerText = sinLeer;
        // Animación simple si hay nuevas
        if(sinLeer > 0){
            badge.style.display = 'block';
            badge.classList.add('heartbit'); // Clase de animación si tu tema la tiene
        } else {
            badge.style.display = 'none';
        }
    }

    // Utilidad: Tiempo relativo
    function calcularTiempo(fechaStr) {
        if(!fechaStr) return "";
        // Convertir formato SQL a JS compatible
        let fecha = new Date(fechaStr.replace(/-/g, "/"));
        let segundos = Math.floor((new Date() - fecha) / 1000);
        
        let intervalo = segundos / 31536000;
        if (intervalo > 1) return "hace " + Math.floor(intervalo) + " años";
        intervalo = segundos / 2592000;
        if (intervalo > 1) return "hace " + Math.floor(intervalo) + " m.";
        intervalo = segundos / 86400;
        if (intervalo > 1) return "hace " + Math.floor(intervalo) + " d.";
        intervalo = segundos / 3600;
        if (intervalo > 1) return "hace " + Math.floor(intervalo) + " h.";
        intervalo = segundos / 60;
        if (intervalo > 1) return "hace " + Math.floor(intervalo) + " min.";
        return "ahora mismo";
    }

    // Acción al hacer click
    window.marcarYVer = function(idNotificacion) {
        // 1. Llamada visual inmediata (opcional)
        console.log("Abriendo notificación: " + idNotificacion);
        
        // 2. Aquí podrías llamar a AJAX/Execute.php para UPDATE Notificaciones SET Leido=1 WHERE ID=...
        // y luego redirigir si el campo JSON 'Datos' tiene una URL.
    };

})();
</script>