<?php
/* ==============================================================================
   MÓDULO: RECEPCIÓN UNIVERSAL DE MERCANCÍA (VISUALIZACIÓN TOTAL)
   ============================================================================== */
session_start();
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') { die("Acceso Denegado"); }

header('Content-Type: text/html; charset=utf-8');

// --- 1. CONFIGURACIÓN DB ---
$bd_datos  = "MS_Datos";    // Base Local
$bd_global = "MS_Usuario";  // Hub de Transferencias

// --- 2. CONTEXTO ---
// Obtenemos el prefijo de la sucursal ACTUAL (la que está recibiendo)
$prefijo = isset($_GET['IDU']) ? $_GET['IDU'] : ($_SESSION['IDU'] ?? '101'); 
$ID_Usuario_Actual = $_SESSION['IDU'] ?? '0';

// --- 3. TABLAS BASE ---
$tb_trans = "Transferencias"; 
?>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    body { background-color: #f4f6f9; font-family: 'Segoe UI', sans-serif; }
    
    /* UI SCANNER PRO */
    .main-card {
        max-width: 900px; margin: 30px auto; border: 0; border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.08); overflow: hidden;
    }
    .card-header-custom {
        background: linear-gradient(135deg, #0f2027 0%, #203a43 50%, #2c5364 100%);
        color: white; padding: 25px; text-align: center;
    }
    
    .input-scanner {
        height: 70px; font-size: 1.8rem; text-align: center; border: 3px solid #e9ecef;
        border-radius: 12px; font-weight: 800; letter-spacing: 3px; color: #333;
        transition: all 0.3s; background: #f8f9fa;
    }
    .input-scanner:focus {
        border-color: #2c5364; background: #fff;
        box-shadow: 0 0 0 0.3rem rgba(44, 83, 100, 0.25); outline: none;
    }

    .status-badge {
        font-size: 0.85rem; padding: 6px 15px; border-radius: 30px;
        text-transform: uppercase; font-weight: 800; letter-spacing: 1px;
    }
    .status-TRANSITO { background: #fff3cd; color: #856404; border: 1px solid #ffeeba; }
    .status-RECIBIDA { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }

    /* TAGS DE SERIES */
    .serie-tag {
        display: inline-block; background: #fff; border: 1px solid #ced4da;
        border-radius: 4px; padding: 2px 8px; font-family: monospace;
        font-size: 0.9rem; margin-right: 5px; margin-bottom: 5px; color: #333;
    }
    .serie-tag i { color: #6c757d; margin-right: 4px; }

    /* ANIMACIONES */
    .fade-in { animation: fadeIn 0.6s cubic-bezier(0.23, 1, 0.32, 1) forwards; opacity: 0; transform: translateY(20px); }
    @keyframes fadeIn { to { opacity: 1; transform: translateY(0); } }
</style>

<div class="container-fluid">

    <div class="card main-card">
        <div class="card-header-custom">
            <h2 class="font-weight-bold m-0"><i class="fas fa-dolly mr-2"></i>Recepción de Mercancía</h2>
            <p class="mb-0 text-white-50">Ingreso Universal con Validación de Series</p>
        </div>

        <div class="card-body p-5">
            
            <div class="form-group text-center mb-5">
                <label class="text-uppercase text-muted font-weight-bold small mb-3">Escanea el código QR o escribe el folio</label>
                <div class="input-group">
                    <input type="text" id="txt_folio" class="form-control input-scanner" placeholder="TR-..." autofocus autocomplete="off">
                </div>
                <div class="mt-3">
                    <button class="btn btn-dark px-5 font-weight-bold rounded-pill shadow-sm" onclick="buscarPaquete()">
                        <i class="fas fa-search mr-2"></i>BUSCAR TRANSFERENCIA
                    </button>
                </div>
            </div>

            <div id="resultado_panel" class="d-none fade-in">
                <hr class="my-4">
                
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h5 class="font-weight-bold text-dark m-0">Contenido del Envío</h5>
                        <small class="text-muted">Folio: <span id="lbl_uuid" class="font-weight-bold text-primary">---</span></small>
                    </div>
                    <span id="lbl_status" class="status-badge status-TRANSITO">EN TRANSITO</span>
                </div>

                <div class="row text-center mb-4 mx-0 bg-light rounded p-3 border">
                    <div class="col-5">
                        <small class="text-muted font-weight-bold text-uppercase">Origen</small>
                        <div id="lbl_origen_id" class="h6 font-weight-bold text-danger mt-1">---</div>
                    </div>
                    <div class="col-2 align-self-center"><i class="fas fa-chevron-right text-muted"></i></div>
                    <div class="col-5">
                        <small class="text-muted font-weight-bold text-uppercase">Destino (Actual)</small>
                        <div id="lbl_destino_id" class="h6 font-weight-bold text-success mt-1">---</div>
                        <div id="alert_redirect" class="d-none badge badge-warning mt-1">Redireccionado a tu sucursal</div>
                    </div>
                </div>

                <div class="table-responsive border rounded mb-4 shadow-sm" style="max-height: 400px; overflow-y: auto;">
                    <table class="table table-hover mb-0">
                        <thead class="bg-white sticky-top shadow-sm">
                            <tr>
                                <th class="pl-4 border-top-0" style="width: 60%">Producto / Descripción / Series</th>
                                <th class="text-center border-top-0">Tipo</th>
                                <th class="text-center border-top-0">Cant.</th>
                            </tr>
                        </thead>
                        <tbody id="tbody_items"></tbody>
                    </table>
                </div>

                <div id="btn_action_container">
                    <button class="btn btn-success btn-lg btn-block font-weight-bold shadow py-3" onclick="confirmarIngreso()">
                        <i class="fas fa-file-import mr-2"></i> INGRESAR A MI INVENTARIO
                    </button>
                </div>
            </div>

            <div id="empty_state" class="text-center py-4 opacity-50">
                <i class="fas fa-barcode fa-4x mb-3 text-secondary"></i>
                <p class="text-muted">Listo para escanear.</p>
            </div>

        </div>
    </div>
</div>

<script>
    // --- CONFIGURACIÓN ---
    const DB_DATOS  = "<?php echo $bd_datos; ?>";
    const DB_GLOBAL = "<?php echo $bd_global; ?>";
    const T_TRANS   = "<?php echo $tb_trans; ?>";
    const USER_ID   = "<?php echo $ID_Usuario_Actual; ?>";
    const SUCURSAL_ACTUAL = "<?php echo $prefijo; ?>"; // La sucursal que está operando el sistema

    let paqueteActual = null;
    let sucursalesNombres = {};

    $(document).ready(function() {
        cargarNombresSucursales();
        $('#txt_folio').on('keypress', function(e) { if(e.which == 13) buscarPaquete(); });
    });

    async function cargarNombresSucursales() {
        // Carga nombres para mostrar bonito (Origen -> Destino)
        const tablaSuc = `${SUCURSAL_ACTUAL}-Sucursales`;
        const res = await apiSelect(`SELECT IDS, nombre FROM \`${DB_DATOS}\`.\`${tablaSuc}\``, DB_DATOS);
        (res.data || []).forEach(s => sucursalesNombres[s.IDS] = s.nombre);
        // Nos aseguramos que nuestra sucursal tenga nombre
        if(!sucursalesNombres[SUCURSAL_ACTUAL]) sucursalesNombres[SUCURSAL_ACTUAL] = "Mi Sucursal (" + SUCURSAL_ACTUAL + ")";
    }

    // --- 1. BUSCAR PAQUETE ---
    async function buscarPaquete() {
        const folio = $('#txt_folio').val().trim();
        if(!folio) return;

        Swal.showLoading();
        // Buscamos el paquete globalmente
        const sql = `SELECT * FROM \`${DB_GLOBAL}\`.\`${T_TRANS}\` WHERE UUID_Unico = '${folio}' LIMIT 1`;
        const res = await apiSelect(sql, DB_GLOBAL);
        Swal.close();

        if((res.data || []).length === 0) {
            Swal.fire('Error', 'Folio no encontrado.', 'error');
            limpiarUI(); return;
        }

        paqueteActual = res.data[0];
        renderPaquete();
    }

    // --- 2. RENDERIZADO VISUAL COMPLETO ---
    function renderPaquete() {
        $('#empty_state').addClass('d-none');
        $('#resultado_panel').removeClass('d-none').addClass('fade-in');

        const pkt = paqueteActual;
        
        // Header
        $('#lbl_uuid').text(pkt.UUID_Unico);
        $('#lbl_origen_id').text(sucursalesNombres[pkt.IDS_Origen] || `Sucursal ${pkt.IDS_Origen}`);
        
        // Lógica de Redirección (Si venía para otro, lo mostramos igual pero avisamos)
        if(pkt.IDS_Destino != SUCURSAL_ACTUAL) {
            $('#lbl_destino_id').text(sucursalesNombres[SUCURSAL_ACTUAL]); // Mostramos DONDE VA A CAER (Aquí)
            $('#alert_redirect').removeClass('d-none').text(`Originalmente para: ${pkt.IDS_Destino}`);
        } else {
            $('#lbl_destino_id').text(sucursalesNombres[pkt.IDS_Destino] || `Sucursal ${pkt.IDS_Destino}`);
            $('#alert_redirect').addClass('d-none');
        }

        // Status
        $('#lbl_status').text(pkt.Estado)
            .removeClass('status-TRANSITO status-RECIBIDA')
            .addClass(pkt.Estado === 'RECIBIDA' ? 'status-RECIBIDA' : 'status-TRANSITO');

        // Render de Productos
        const items = JSON.parse(pkt.Contenido_Paquete);
        const tbody = $('#tbody_items').empty();

        items.forEach(i => {
            let htmlSeries = '';
            let badge = '<span class="badge badge-secondary">Normal</span>';
            
            // Si tiene series, las mostramos TODAS
            if(i.series && i.series.length > 0) {
                badge = '<span class="badge badge-info">Serie</span>';
                // Generamos los tags visuales
                const tags = i.series.map(s => `<span class="serie-tag"><i class="fas fa-barcode"></i> ${s}</span>`).join('');
                htmlSeries = `<div class="mt-2 p-2 bg-light rounded border">${tags}</div>`;
            }

            tbody.append(`
                <tr>
                    <td class="pl-4 align-middle">
                        <div class="font-weight-bold text-dark h6 mb-0">${i.nombre}</div>
                        <div class="small text-muted font-monospace"><i class="fas fa-tag mr-1"></i>SKU: ${i.sku}</div>
                        ${htmlSeries}
                    </td>
                    <td class="text-center align-middle">${badge}</td>
                    <td class="text-center align-middle font-weight-bold h4">${i.cantidad}</td>
                </tr>
            `);
        });

        // Control del Botón
        if(pkt.Estado !== 'EN_TRANSITO') {
            $('#btn_action_container').html('<div class="alert alert-warning text-center font-weight-bold p-3"><i class="fas fa-lock mr-2"></i>Este paquete ya fue procesado.</div>');
        } else {
            // SIEMPRE habilitado (Requisito: "No importa quien jale la transferencia")
            const btnText = (pkt.IDS_Destino != SUCURSAL_ACTUAL) ? "JALAR TRANSFERENCIA (Redireccionar)" : "INGRESAR A MI INVENTARIO";
            const btnColor = (pkt.IDS_Destino != SUCURSAL_ACTUAL) ? "btn-warning" : "btn-success";
            
            $('#btn_action_container').html(`
                <button class="btn ${btnColor} btn-lg btn-block font-weight-bold shadow py-3" onclick="confirmarIngreso()">
                    <i class="fas fa-file-import mr-2"></i> ${btnText}
                </button>
            `);
        }
    }

    // --- 3. PROCESAR INGRESO (CON REDIRECCIÓN INTELIGENTE) ---
    function confirmarIngreso() {
        Swal.fire({
            title: '¿Confirmar Ingreso?',
            text: "Los productos y series se agregarán a TU inventario actual.",
            icon: 'question', showCancelButton: true, confirmButtonText: 'Sí, Ingresar', confirmButtonColor: '#28a745'
        }).then(async (r) => {
            if(r.isConfirmed) {
                Swal.showLoading();
                try {
                    const items = JSON.parse(paqueteActual.Contenido_Paquete);
                    const idOrig = paqueteActual.IDS_Origen;
                    // IMPORTANTE: Forzamos el destino a la SUCURSAL ACTUAL (quien escanea)
                    const idDest = SUCURSAL_ACTUAL; 

                    // Tablas Dinámicas
                    const tb_inv_dest = `${idDest}-Productos_Inventario`;
                    const tb_mov_dest = `${idDest}-Productos_Movimientos`;
                    const tb_ser_dest = `${idDest}-Productos_Series`; 
                    const tb_ser_orig = `${idOrig}-Productos_Series`; 

                    for(let i of items) {
                        // A. Sumar Stock (UPSERT)
                        let sql = `INSERT INTO \`${DB_DATOS}\`.\`${tb_inv_dest}\` (IDP, sku, IDS, existencia, costo_promedio, precio_venta, stock_minimo, stock_maximo) 
                                   VALUES ('0', '${i.sku}', ${idDest}, ${i.cantidad}, ${i.costo||0}, ${i.precio||0}, 0, 0) 
                                   ON DUPLICATE KEY UPDATE existencia = existencia + ${i.cantidad}; `;
                        
                        // B. Registrar Movimiento (Kardex)
                        sql += `INSERT INTO \`${DB_DATOS}\`.\`${tb_mov_dest}\` (sku, IDS_Origen, IDS_Destino, cantidad, tipo_movimiento, IDU_Usuario, notas) 
                                VALUES ('${i.sku}', ${idOrig}, ${idDest}, ${i.cantidad}, 'ENTRADA_TRANSFER', '${USER_ID}', 'Folio: ${paqueteActual.UUID_Unico}'); `;

                        // C. Mover Series (SQL Magia: Copia y Borra)
                        if(i.series && i.series.length > 0) {
                            const listaSeries = i.series.map(s => `'${s}'`).join(',');
                            
                            // Copiar a la tabla destino (tu sucursal)
                            sql += `INSERT INTO \`${DB_DATOS}\`.\`${tb_ser_dest}\` (SKU, Serie, ID_Compra, Estado, Fecha_Entrada)
                                    SELECT SKU, Serie, ID_Compra, 'DISPONIBLE', Fecha_Entrada 
                                    FROM \`${DB_DATOS}\`.\`${tb_ser_orig}\`
                                    WHERE SKU='${i.sku}' AND Serie IN (${listaSeries}); `;

                            // Borrar de la tabla origen
                            sql += `DELETE FROM \`${DB_DATOS}\`.\`${tb_ser_orig}\` 
                                    WHERE SKU='${i.sku}' AND Serie IN (${listaSeries}); `;
                        }
                        await apiExecute(sql, DB_DATOS);
                    }

                    // D. Actualizar Global (Marcamos quién la recibió realmente)
                    // Actualizamos IDS_Destino por si fue redireccionada ("jalada")
                    const sqlClose = `UPDATE \`${DB_GLOBAL}\`.\`${T_TRANS}\` 
                                      SET Estado = 'RECIBIDA', Fecha_Entrada = NOW(), IDU_Receptor = '${USER_ID}', IDS_Destino = '${idDest}' 
                                      WHERE UUID_Unico = '${paqueteActual.UUID_Unico}'`;
                    await apiExecute(sqlClose, DB_GLOBAL);

                    Swal.fire('¡Recibido!', 'Inventario ingresado correctamente.', 'success').then(() => {
                        $('#txt_folio').val('').focus(); limpiarUI();
                    });

                } catch (e) {
                    console.error(e);
                    Swal.fire('Error', 'Fallo en base de datos. Verifica consola.', 'error');
                }
            }
        });
    }

    function limpiarUI() { $('#resultado_panel').addClass('d-none'); $('#empty_state').removeClass('d-none'); paqueteActual = null; }

    async function apiSelect(sql, db) {
        try { const fd = new FormData(); fd.append('sql', sql); fd.append('db', db); return await (await fetch('../librerias/AJAX/Select.php', { method: 'POST', body: fd })).json(); } catch(e) { return {data:[]}; }
    }

    async function apiExecute(sql, db) {
        try { const fd = new FormData(); fd.append('sql', sql); fd.append('db', db); return await (await fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: fd })).json(); } catch(e) { return {error: e}; }
    }
</script>