<?php
// 1. CONFIGURACIÓN
header('Content-Type: text/html; charset=utf-8');
session_start();

if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso Denegado");
}

$IDU_SESSION = $_SESSION['IDU'] ?? '101'; 
$prefijo = isset($IDU) ? $IDU : $IDU_SESSION;
$nombre_bd = "MS_Datos";

// Tablas
$tbl_catalogo = $prefijo . "-Productos_Catalogo"; 
$tbl_inventario = $prefijo . "-Productos_Inventario";
$tbl_sucursales = $prefijo . "-Sucursales";
$tbl_proveedores = $prefijo . "-Proveedores";
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<style>
    /* === FIX PARA QUE OCUPE TODA LA PANTALLA === */
    .modal-super-ancho {
        max-width: 98% !important; /* Fuerza el ancho casi total */
        width: 98% !important;
        margin: 10px auto;
    }
    
    .modal-body-scroll {
        max-height: 85vh; /* Altura máxima para pantallas pequeñas */
        overflow-y: auto;
        padding: 2rem !important; /* Espacio interno generoso */
    }

    /* Estilos Generales */
    .table { width: 100% !important; margin-bottom: 0; }
    .table-hover tbody tr:hover { background-color: #f1f3f5; cursor: pointer; }
    
    .img-producto-tabla {
        width: 50px; height: 50px; object-fit: contain;
        background: #fff; border-radius: 6px; border: 1px solid #dee2e6; padding: 2px;
    }
    
    .sku-badge {
        background: #e3f2fd; color: #0d47a1; 
        padding: 4px 8px; border-radius: 4px; font-family: monospace; font-weight: bold; font-size: 0.9rem;
    }

    /* Caja de previsualización más grande */
    .image-preview-container {
        width: 100%; height: 220px; background-color: #f8f9fa;
        border: 2px dashed #dee2e6; border-radius: 8px;
        display: flex; align-items: center; justify-content: center;
        overflow: hidden; margin-bottom: 1rem;
    }
    .image-preview-container img { max-width: 100%; max-height: 100%; }

    /* Separadores visuales */
    .border-right-custom { border-right: 1px solid #dee2e6; }
    
    /* Colores Inventario */
    .bg-money { background-color: #f0fff4; } 
    .text-money { color: #2f855a; }
</style>

<div class="container-fluid p-0">
    <div class="card border-0 shadow-sm rounded-3 mt-3">
        <div class="card-header bg-white py-3 px-4 border-bottom">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h4 class="mb-0 text-dark font-weight-bold">📦 Catálogo Maestro</h4>
                    <small class="text-muted">Gestión completa de productos</small>
                </div>
                <div class="col-md-6 text-end">
                    <div class="d-flex justify-content-end gap-2">
                        <div class="input-group" style="width: 300px;">
                            <input type="text" id="buscador" class="form-control" placeholder="🔍 Buscar SKU, Nombre, Marca...">
                        </div>
                        <button class="btn btn-dark" onclick="abrirModal()">
                            <i class="fas fa-plus-circle"></i> Nuevo
                        </button>
                        <button class="btn btn-light border" onclick="listarProductos()" title="Recargar">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted">
                    <tr>
                        <th class="ps-4" width="80">Imagen</th>
                        <th>Identificación</th>
                        <th>Descripción</th>
                        <th>Clasificación</th>
                        <th>Proveedor</th>
                        <th class="text-center">Estado</th>
                        <th class="text-end pe-4">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos"></tbody>
            </table>
        </div>
    </div>
</div>

<div id="modalProducto" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-super-ancho" role="document">
        <div class="modal-content h-100 shadow-lg">
            <div class="modal-header bg-light py-3 px-4">
                <h5 class="modal-title font-weight-bold text-dark" id="modalTitulo">Nuevo Producto</h5>
                <div>
                    <button type="button" class="btn btn-outline-secondary mr-2" onclick="$('#modalProducto').modal('hide');">Cancelar</button>
                    <button type="button" class="btn btn-primary px-4" onclick="guardarProducto()">
                        <i class="fas fa-save mr-1"></i> Guardar Cambios
                    </button>
                </div>
            </div>
            
            <div class="modal-body modal-body-scroll bg-white">
                <form id="formProducto">
                    <input type="hidden" id="IDP_Prod" name="IDP">
                    
                    <div class="row">
                        <div class="col-lg-3 border-right-custom px-4">
                            <h6 class="text-primary font-weight-bold mb-3 border-bottom pb-2">IMAGEN & ID</h6>
                            
                            <div class="image-preview-container shadow-sm">
                                <div id="preview_placeholder" class="text-center text-muted"><i class="fas fa-image fa-4x mb-2"></i><br>Sin Imagen</div>
                                <img id="preview_img" src="" style="display:none;" onerror="this.style.display='none'; document.getElementById('preview_placeholder').style.display='block';">
                            </div>
                            
                            <div class="form-group mb-4">
                                <label class="form-label font-weight-bold">URL Imagen</label>
                                <input type="text" class="form-control" id="imagen" placeholder="http://..." onchange="actualizarPreview(this.value)" onkeyup="actualizarPreview(this.value)">
                            </div>
                            
                            <div class="card bg-light border-0 p-3">
                                <div class="form-group mb-3">
                                    <label class="form-label text-danger font-weight-bold">SKU (Único) *</label>
                                    <input type="text" class="form-control font-weight-bold border-danger" id="sku" required placeholder="Ej: PROD-001">
                                </div>
                                <div class="form-group mb-0">
                                    <label class="form-label">Código Barras</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-white"><i class="fas fa-barcode"></i></span>
                                        <input type="text" class="form-control" id="codigo_barras">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-5 border-right-custom px-4">
                            <h6 class="text-primary font-weight-bold mb-3 border-bottom pb-2">DATOS GENERALES</h6>
                            
                            <div class="form-group mb-3">
                                <label class="form-label font-weight-bold" style="font-size:1.1em;">Nombre del Producto *</label>
                                <input type="text" class="form-control form-control-lg font-weight-bold" id="nombre" required placeholder="Nombre comercial del producto">
                            </div>
                            
                            <div class="form-group mb-4">
                                <label class="form-label text-primary"><i class="fas fa-truck"></i> Proveedor Asignado</label>
                                <select class="form-control" id="IDPr">
                                    <option value="0">-- Sin Asignar --</option>
                                </select>
                            </div>

                            <div class="row">
                                <div class="col-md-6 form-group mb-3">
                                    <label class="form-label">Categoría</label>
                                    <input type="text" class="form-control" id="categoria" list="lista_categorias" placeholder="Ej: Electrónica">
                                    <datalist id="lista_categorias"></datalist>
                                </div>
                                <div class="col-md-6 form-group mb-3">
                                    <label class="form-label">Marca</label>
                                    <input type="text" class="form-control" id="marca" list="lista_marcas" placeholder="Ej: Sony">
                                    <datalist id="lista_marcas"></datalist>
                                </div>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label class="form-label">Descripción Corta (Subtítulo)</label>
                                <input type="text" class="form-control" id="descripcion_corta">
                            </div>
                            
                            <div class="form-group mb-3">
                                <label class="form-label">Descripción Detallada</label>
                                <textarea class="form-control" id="descripcion" rows="5" placeholder="Detalles técnicos, características, etc."></textarea>
                            </div>
                        </div>

                        <div class="col-lg-4 px-4">
                            <h6 class="text-primary font-weight-bold mb-3 border-bottom pb-2">CONFIGURACIÓN</h6>
                            
                            <div class="row">
                                <div class="col-6 form-group mb-3"><label class="form-label">Modelo</label><input type="text" class="form-control" id="modelo"></div>
                                <div class="col-6 form-group mb-3"><label class="form-label">Capacidad/Talla</label><input type="text" class="form-control" id="capacidad"></div>
                            </div>
                            
                            <div class="row">
                                <div class="col-6 form-group mb-3">
                                    <label class="form-label">Unidad Medida</label>
                                    <select class="form-control" id="unidad_medida">
                                        <option value="Pza">Pieza (Pza)</option>
                                        <option value="Kg">Kilogramo (Kg)</option>
                                        <option value="Lt">Litro (Lt)</option>
                                        <option value="Caja">Caja</option>
                                        <option value="Svc">Servicio</option>
                                    </select>
                                </div>
                                <div class="col-6 form-group mb-3">
                                    <label class="form-label">Tipo Item</label>
                                    <select class="form-control" id="tipo_item">
                                        <option value="producto">Producto Físico</option>
                                        <option value="servicio">Servicio</option>
                                        <option value="kit">Kit / Combo</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="card p-3 mb-3 border bg-light">
                                <div class="form-group mb-2">
                                    <label class="form-label font-weight-bold">Control de Inventario</label>
                                    <select class="form-control" id="controlar_stock">
                                        <option value="1">✅ Sí (Descontar Stock)</option>
                                        <option value="0">♾️ No (Stock Infinito)</option>
                                    </select>
                                </div>
                                <div class="form-group mb-0 mt-3">
                                    <label class="form-label font-weight-bold">Estado del Producto</label>
                                    <select class="form-control" id="activo">
                                        <option value="1">🟢 Activo (Visible)</option>
                                        <option value="0">🔴 Inactivo (Oculto)</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">Datos JSON (Avanzado)</label>
                                <textarea class="form-control text-muted" style="font-family:monospace; font-size:0.85em;" id="Datos" rows="3">{}</textarea>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="modalInventario" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-super-ancho" role="document">
        <div class="modal-content h-100 shadow-lg">
            <div class="modal-header d-flex justify-content-between align-items-center bg-money py-3 px-4">
                <div>
                    <h5 class="modal-title font-weight-bold text-money" id="tituloInv">Gestión de Inventario</h5>
                    <small class="text-secondary" id="subtituloInv">SKU: ---</small>
                </div>
                <div>
                    <button type="button" class="btn btn-outline-secondary mr-2" onclick="$('#modalInventario').modal('hide');">Cerrar</button>
                    <button type="button" class="btn btn-success px-4" onclick="guardarInventario()">
                        <i class="fas fa-save mr-1"></i> Actualizar Precios
                    </button>
                </div>
            </div>

            <div class="modal-body modal-body-scroll bg-white">
                <form id="formInventario">
                    <input type="hidden" id="inv_idi" name="IDI"> 
                    <input type="hidden" id="inv_sku" name="sku">

                    <div class="row justify-content-center">
                        <div class="col-lg-4 border-right-custom px-4">
                            <div class="card shadow-sm border-success mb-3">
                                <div class="card-header bg-money text-money font-weight-bold py-2">💲 PRECIOS BASE</div>
                                <div class="card-body">
                                    <div class="form-group mb-3">
                                        <label class="form-label">Costo Promedio (Compra)</label>
                                        <div class="input-group"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_costo_promedio"></div>
                                    </div>
                                    <hr>
                                    <div class="form-group mb-4">
                                        <label class="form-label text-success font-weight-bold" style="font-size: 1.2em;">Precio Público</label>
                                        <div class="input-group input-group-lg"><span class="input-group-text bg-success text-white">$</span><input type="number" step="0.01" class="form-control font-weight-bold text-success" id="inv_precio_venta"></div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6 form-group mb-3"><label class="form-label">Precio Mayoreo</label><div class="input-group input-group-sm"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_precio_mayoreo"></div></div>
                                        <div class="col-6 form-group mb-3"><label class="form-label text-info">Precio Web</label><div class="input-group input-group-sm"><span class="input-group-text bg-info text-white">$</span><input type="number" step="0.01" class="form-control" id="inv_precio_web"></div></div>
                                    </div>
                                    <div class="form-group mb-3"><label class="form-label">Impuesto % (IVA)</label><input type="number" step="0.01" class="form-control" id="inv_impuesto_porcentaje" value="0.00"></div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 border-right-custom px-4">
                            <h6 class="text-primary font-weight-bold mb-3 border-bottom pb-2">📑 LISTAS DE PRECIOS ADICIONALES</h6>
                            <div class="bg-light p-3 rounded">
                                <div class="row">
                                    <div class="col-12 mb-3"><label class="form-label font-weight-bold">Lista 1</label><div class="input-group"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_Precio_1"></div></div>
                                    <div class="col-12 mb-3"><label class="form-label font-weight-bold">Lista 2</label><div class="input-group"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_Precio_2"></div></div>
                                    <div class="col-12 mb-3"><label class="form-label font-weight-bold">Lista 3</label><div class="input-group"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_Precio_3"></div></div>
                                    <div class="col-6 mb-2"><label class="form-label small">Lista 4</label><div class="input-group input-group-sm"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_Precio_4"></div></div>
                                    <div class="col-6 mb-2"><label class="form-label small">Lista 5</label><div class="input-group input-group-sm"><span class="input-group-text">$</span><input type="number" step="0.01" class="form-control" id="inv_Precio_5"></div></div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 px-4">
                             <div class="card shadow-sm mb-3">
                                <div class="card-header bg-light font-weight-bold">🚛 LOGÍSTICA (Sucursal 1)</div>
                                <div class="card-body">
                                    <div class="form-group mb-3"><label class="form-label">Ubicación Física</label><input type="text" class="form-control" id="inv_ubicacion_fisica" placeholder="Ej: Pasillo A, Estante 3"></div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-6 form-group mb-3"><label class="form-label">Stock Min</label><input type="number" class="form-control" id="inv_stock_minimo" value="5"></div>
                                        <div class="col-6 form-group mb-3"><label class="form-label">Stock Max</label><input type="number" class="form-control" id="inv_stock_maximo" value="1000"></div>
                                    </div>
                                    <div class="form-group mt-3">
                                        <label class="form-label text-muted">Existencia Actual (Solo Lectura)</label>
                                        <input type="text" class="form-control bg-light font-weight-bold form-control-lg text-center" id="inv_existencia" readonly>
                                        <small class="text-muted d-block mt-1 text-center">Para ajustar, ir a Movimientos</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    const DB_NAME = "<?php echo $nombre_bd; ?>";
    const T_CAT = "<?php echo $tbl_catalogo; ?>";
    const T_INV = "<?php echo $tbl_inventario; ?>";
    const T_PROV = "<?php echo $tbl_proveedores; ?>";
    const safe = (str) => str ? String(str).replace(/'/g, "\\'") : '';

    document.addEventListener("DOMContentLoaded", function() {
        listarProductos();
        cargarDatalists();
        cargarProveedores();
        const input = document.getElementById('buscador');
        if(input) input.addEventListener('keyup', function() { filtrarTabla(this.value); });
    });

    // --- CARGAR PROVEEDORES ---
    function cargarProveedores() {
        const sql = `SELECT IDPr, razon_social FROM \`${T_PROV}\` WHERE activo = 1 ORDER BY razon_social ASC`;
        fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            const sel = document.getElementById('IDPr');
            sel.innerHTML = '<option value="0">-- Sin Asignar --</option>';
            if(res.data) { res.data.forEach(p => sel.innerHTML += `<option value="${p.IDPr}">${p.razon_social}</option>`); }
        });
    }

    // --- LISTAR ---
    function listarProductos() {
        const sql = `
            SELECT p.IDP, p.sku, p.nombre, p.descripcion_corta, p.categoria, p.marca, p.tipo_item, p.activo, p.imagen, p.codigo_barras, p.unidad_medida, 
            pr.razon_social 
            FROM \`${T_CAT}\` p 
            LEFT JOIN \`${T_PROV}\` pr ON p.IDPr = pr.IDPr 
            ORDER BY p.IDP DESC LIMIT 100`;

        fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            const tbody = document.getElementById('tbody_productos');
            tbody.innerHTML = '';
            
            if(res.error) { tbody.innerHTML = `<tr><td colspan="7" class="text-center text-danger py-4">Error BD: ${res.error}</td></tr>`; return; }

            if (res.data && res.data.length > 0) {
                res.data.forEach(row => {
                    const imgUrl = (row.imagen && row.imagen.length > 4) ? row.imagen : 'https://via.placeholder.com/50?text=--';
                    const iconEstado = row.activo == 1 
                        ? `<i class="fas fa-toggle-on text-success fa-lg" onclick="event.stopPropagation(); cambiarEstadoRapido(${row.IDP}, 0)" title="Desactivar" style="cursor:pointer"></i>` 
                        : `<i class="fas fa-toggle-off text-secondary fa-lg" onclick="event.stopPropagation(); cambiarEstadoRapido(${row.IDP}, 1)" title="Activar" style="cursor:pointer"></i>`;
                    
                    const prov = row.razon_social ? `<br><small class="text-primary"><i class="fas fa-truck"></i> ${row.razon_social}</small>` : '';

                    tbody.innerHTML += `
                        <tr ondblclick='editarProducto(${row.IDP})' class="fila-producto">
                            <td class="pl-4 ps-4"><img src="${imgUrl}" class="img-producto-tabla shadow-sm"></td>
                            <td>
                                <span class="sku-badge mb-1 d-inline-block">${row.sku}</span><br>
                                <span class="text-muted small"><i class="fas fa-barcode"></i> ${row.codigo_barras || ''}</span>
                            </td>
                            <td><div class="font-weight-bold text-dark">${row.nombre}</div><div class="small text-muted text-truncate" style="max-width: 250px;">${row.descripcion_corta || ''}</div></td>
                            <td><span class="badge bg-light text-dark border">${row.categoria || '-'}</span><div class="small text-muted mt-1">${row.marca || ''}</div></td>
                            <td>${prov}</td>
                            <td class="text-center">${iconEstado}</td>
                            <td class="text-end pe-4">
                                <button class="btn btn-sm btn-light border mr-1" onclick="event.stopPropagation(); abrirInventario('${row.sku}', '${safe(row.nombre)}')" title="Inventario"><i class="fas fa-box-open text-success"></i></button>
                                <button class="btn btn-sm btn-light border mr-1" onclick='editarProducto(${row.IDP})' title="Editar"><i class="fas fa-edit text-primary"></i></button>
                                <button class="btn btn-sm btn-light border" onclick="event.stopPropagation(); eliminarProducto(${row.IDP}, '${row.sku}')" title="Eliminar"><i class="fas fa-trash-alt text-danger"></i></button>
                            </td>
                        </tr>`;
                });
            } else { tbody.innerHTML = `<tr><td colspan="7" class="text-center py-5 text-muted">No hay productos registrados</td></tr>`; }
        });
    }

    // --- GUARDAR ---
    function guardarProducto() {
        const id = document.getElementById('IDP_Prod').value;
        const p = {
            sku: document.getElementById('sku').value.trim(),
            codigo: document.getElementById('codigo_barras').value,
            nombre: document.getElementById('nombre').value.trim(),
            desc_c: document.getElementById('descripcion_corta').value,
            desc: document.getElementById('descripcion').value,
            img: document.getElementById('imagen').value || 'default.png',
            cat: document.getElementById('categoria').value,
            marca: document.getElementById('marca').value,
            mod: document.getElementById('modelo').value,
            unidad: document.getElementById('unidad_medida').value,
            cap: document.getElementById('capacidad').value,
            tipo: document.getElementById('tipo_item').value,
            stock: document.getElementById('controlar_stock').value,
            datos: document.getElementById('Datos').value,
            act: document.getElementById('activo').value,
            IDPr: document.getElementById('IDPr').value 
        };

        if(!p.sku || !p.nombre) { Swal.fire('Atención', 'SKU y Nombre son obligatorios', 'warning'); return; }

        let sql = id 
            ? `UPDATE \`${T_CAT}\` SET sku='${safe(p.sku)}', codigo_barras='${safe(p.codigo)}', nombre='${safe(p.nombre)}', descripcion_corta='${safe(p.desc_c)}', descripcion='${safe(p.desc)}', imagen='${safe(p.img)}', categoria='${safe(p.cat)}', marca='${safe(p.marca)}', modelo='${safe(p.mod)}', unidad_medida='${safe(p.unidad)}', capacidad='${safe(p.cap)}', tipo_item='${safe(p.tipo)}', controlar_stock='${p.stock}', Datos='${safe(p.datos)}', activo='${p.act}', IDPr='${p.IDPr}' WHERE IDP = ${id}`
            : `INSERT INTO \`${T_CAT}\` (sku, codigo_barras, nombre, descripcion_corta, descripcion, imagen, categoria, marca, modelo, unidad_medida, capacidad, tipo_item, controlar_stock, Datos, activo, IDPr) VALUES ('${safe(p.sku)}', '${safe(p.codigo)}', '${safe(p.nombre)}', '${safe(p.desc_c)}', '${safe(p.desc)}', '${safe(p.img)}', '${safe(p.cat)}', '${safe(p.marca)}', '${safe(p.mod)}', '${safe(p.unidad)}', '${safe(p.cap)}', '${safe(p.tipo)}', '${p.stock}', '${safe(p.datos)}', '${p.act}', '${p.IDPr}')`;

        fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            if(res.error) {
                Swal.fire('Error al Guardar', res.error, 'error');
            } else {
                if (!id) {
                    const sqlInv = `INSERT IGNORE INTO \`${T_INV}\` (IDP, sku, IDS, existencia) VALUES ('${safe(p.sku)}', '${safe(p.sku)}', 1, 0)`;
                    fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sqlInv)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} });
                }
                Swal.fire({icon: 'success', title: 'Guardado', toast: true, position: 'top-end', showConfirmButton: false, timer: 1500});
                
                // Cierre manual con jQuery
                $('#modalProducto').modal('hide');
                listarProductos();
                cargarDatalists();
            }
        });
    }

    // --- INVENTARIO ---
    function abrirInventario(sku, nombre) {
        document.getElementById('formInventario').reset();
        document.getElementById('tituloInv').innerText = "Inventario: " + nombre;
        document.getElementById('subtituloInv').innerText = "SKU: " + sku;
        document.getElementById('inv_sku').value = sku;

        const sql = `SELECT * FROM \`${T_INV}\` WHERE sku = '${safe(sku)}' AND IDS = 1 LIMIT 1`;
        fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            if(res.data && res.data.length > 0) {
                const d = res.data[0];
                document.getElementById('inv_idi').value = d.IDI;
                document.getElementById('inv_costo_promedio').value = d.costo_promedio;
                document.getElementById('inv_precio_venta').value = d.precio_venta;
                document.getElementById('inv_precio_mayoreo').value = d.precio_mayoreo;
                document.getElementById('inv_precio_web').value = d.precio_web || 0;
                document.getElementById('inv_Precio_1').value = d.Precio_1 || 0;
                document.getElementById('inv_Precio_2').value = d.Precio_2 || 0;
                document.getElementById('inv_Precio_3').value = d.Precio_3 || 0;
                document.getElementById('inv_Precio_4').value = d.Precio_4 || 0;
                document.getElementById('inv_Precio_5').value = d.Precio_5 || 0;
                document.getElementById('inv_impuesto_porcentaje').value = d.impuesto_porcentaje;
                document.getElementById('inv_ubicacion_fisica').value = d.ubicacion_fisica;
                document.getElementById('inv_stock_minimo').value = d.stock_minimo;
                document.getElementById('inv_stock_maximo').value = d.stock_maximo;
                document.getElementById('inv_existencia').value = d.existencia;
            } else {
                document.getElementById('inv_idi').value = '';
                Swal.fire({toast: true, title: 'Creando registro de inventario...', icon: 'info', position: 'top-end', timer: 1500, showConfirmButton:false});
            }
            $('#modalInventario').modal('show');
        });
    }

    function guardarInventario() {
        const idi = document.getElementById('inv_idi').value;
        const sku = document.getElementById('inv_sku').value;
        const i = {
            costo: document.getElementById('inv_costo_promedio').value || 0,
            venta: document.getElementById('inv_precio_venta').value || 0,
            may: document.getElementById('inv_precio_mayoreo').value || 0,
            web: document.getElementById('inv_precio_web').value || 0,
            p1: document.getElementById('inv_Precio_1').value || 0,
            p2: document.getElementById('inv_Precio_2').value || 0,
            p3: document.getElementById('inv_Precio_3').value || 0,
            p4: document.getElementById('inv_Precio_4').value || 0,
            p5: document.getElementById('inv_Precio_5').value || 0,
            iva: document.getElementById('inv_impuesto_porcentaje').value || 0,
            ubi: document.getElementById('inv_ubicacion_fisica').value,
            min: document.getElementById('inv_stock_minimo').value || 0,
            max: document.getElementById('inv_stock_maximo').value || 0
        };

        let sql = "";
        if (idi) {
            sql = `UPDATE \`${T_INV}\` SET costo_promedio='${i.costo}', precio_venta='${i.venta}', precio_mayoreo='${i.may}', precio_web='${i.web}', Precio_1='${i.p1}', Precio_2='${i.p2}', Precio_3='${i.p3}', Precio_4='${i.p4}', Precio_5='${i.p5}', impuesto_porcentaje='${i.iva}', ubicacion_fisica='${safe(i.ubi)}', stock_minimo='${i.min}', stock_maximo='${i.max}' WHERE IDI = ${idi}`;
        } else {
            sql = `INSERT INTO \`${T_INV}\` (IDP, sku, IDS, costo_promedio, precio_venta, precio_mayoreo, precio_web, Precio_1, Precio_2, Precio_3, Precio_4, Precio_5, impuesto_porcentaje, ubicacion_fisica, stock_minimo, stock_maximo) VALUES ('${safe(sku)}', '${safe(sku)}', 1, '${i.costo}', '${i.venta}', '${i.may}', '${i.web}', '${i.p1}', '${i.p2}', '${i.p3}', '${i.p4}', '${i.p5}', '${i.iva}', '${safe(i.ubi)}', '${i.min}', '${i.max}')`;
        }

        fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            if(res.error) Swal.fire('Error', res.error, 'error');
            else {
                Swal.fire({icon: 'success', title: 'Inventario Actualizado', toast: true, position: 'top-end', showConfirmButton: false, timer: 1500});
                $('#modalInventario').modal('hide');
            }
        });
    }

    // --- OTROS ---
    function editarProducto(id) {
        const sql = `SELECT * FROM \`${T_CAT}\` WHERE IDP = ${id}`;
        fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r=>r.json()).then(res => {
             if(res.data && res.data.length > 0){
                 const p = res.data[0];
                 document.getElementById('IDP_Prod').value = p.IDP; 
                 document.getElementById('sku').value = p.sku; document.getElementById('nombre').value = p.nombre; document.getElementById('descripcion_corta').value = p.descripcion_corta || ''; document.getElementById('descripcion').value = p.descripcion || ''; document.getElementById('imagen').value = p.imagen; document.getElementById('categoria').value = p.categoria || ''; document.getElementById('marca').value = p.marca || ''; document.getElementById('modelo').value = p.modelo || ''; document.getElementById('codigo_barras').value = p.codigo_barras || ''; document.getElementById('unidad_medida').value = p.unidad_medida || 'Pza'; document.getElementById('capacidad').value = p.capacidad || ''; document.getElementById('tipo_item').value = p.tipo_item || 'producto'; document.getElementById('controlar_stock').value = p.controlar_stock || 1; document.getElementById('Datos').value = p.Datos || ''; document.getElementById('activo').value = p.activo || 1;
                 document.getElementById('IDPr').value = p.IDPr || 0;
                 document.getElementById('modalTitulo').innerText = "Editar: " + p.nombre; actualizarPreview(p.imagen); $('#modalProducto').modal('show');
             }
        });
    }
    function cambiarEstadoRapido(id, nuevoEstado) { const sql = `UPDATE \`${T_CAT}\` SET activo = '${nuevoEstado}' WHERE IDP = ${id}`; fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} }).then(() => listarProductos()); }
    function eliminarProducto(id, sku) { Swal.fire({ title: '¿Eliminar?', text: "Esto borrará el producto y su inventario", icon: 'warning', showCancelButton: true, confirmButtonColor: '#d33', confirmButtonText: 'Sí, borrar todo' }).then((result) => { if (result.isConfirmed) { const sqlCat = `DELETE FROM \`${T_CAT}\` WHERE IDP = ${id}`; const sqlInv = `DELETE FROM \`${T_INV}\` WHERE sku = '${safe(sku)}'`; fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sqlInv)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} }); fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sqlCat)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} }).then(() => listarProductos()); } }); }
    function actualizarPreview(url) { const img = document.getElementById('preview_img'); const place = document.getElementById('preview_placeholder'); if(url && url.length > 5) { img.src = url; img.style.display = 'block'; place.style.display = 'none'; } else { img.style.display = 'none'; place.style.display = 'block'; } }
    function cargarDatalists() { ['categoria', 'marca'].forEach(campo => { const sql = `SELECT DISTINCT ${campo} FROM \`${T_CAT}\` WHERE ${campo} IS NOT NULL AND ${campo} != ''`; fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB_NAME}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} }).then(r=>r.json()).then(res => { if(res.data) { let opts = ''; res.data.forEach(x => opts += `<option value="${x[campo]}">`); if(document.getElementById('lista_' + campo + 's')) document.getElementById('lista_' + campo + 's').innerHTML = opts; } }); }); }
    function abrirModal() { document.getElementById('formProducto').reset(); document.getElementById('IDP_Prod').value = ''; document.getElementById('modalTitulo').innerText = "Nuevo Producto"; actualizarPreview(''); $('#modalProducto').modal('show'); }
    function filtrarTabla(texto) { const rows = document.querySelectorAll('.fila-producto'); texto = texto.toLowerCase(); rows.forEach(row => { row.style.display = row.innerText.toLowerCase().includes(texto) ? '' : 'none'; }); }
</script>