<?php
session_start();
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') { die("Acceso denegado."); }

$idUsuario = $_SESSION['IDU'] ?? '1'; 
$idSucursal = $_SESSION['IDS'] ?? '1';
$dbName = $_SESSION['BD'] ?? "MS_Datos";

$prefijoTablas = "$IDUg-"; 
$vendedor = $_SESSION['NombreUsuario'] ?? "Vendedor General";
echo "<script> console.log('ID Usuario: $prefijoTablas $vendedor'); </script>";
try {
    $pdo = new PDO("mysql:host=localhost;dbname=$dbName;charset=utf8", "root", "33comRxXMysql"); 
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Lógica de Folio Diario Consecutivo
    $hoy = date('ymd'); 
    $prefijoFolio = "V-" . $hoy . "-";
    $sqlFolio = "SELECT Folio FROM `{$prefijoTablas}Ventas_Cabecera` WHERE Folio LIKE '$prefijoFolio%' ORDER BY ID_Venta DESC LIMIT 1";
    $resFolio = $pdo->query($sqlFolio)->fetch(PDO::FETCH_ASSOC);
    $nuevoContador = $resFolio ? intval(substr($resFolio['Folio'], -3)) + 1 : 1;
    $folioTemp = $prefijoFolio . str_pad($nuevoContador, 3, "0", STR_PAD_LEFT);

    // Cargar Catálogo (Productos + Inventario) - ACTUALIZADO PARA TRAER TODOS LOS PRECIOS Y COSTO
    $productos = $pdo->query("SELECT p.IDP, p.sku, p.nombre, p.imagen, p.codigo_barras, 
                                     i.existencia, i.precio_venta, i.precio_mayoreo, i.precio_web, i.costo_promedio 
                             FROM `{$prefijoTablas}Productos_Catalogo` p 
                             INNER JOIN `{$prefijoTablas}Productos_Inventario` i ON p.sku = i.sku 
                             WHERE p.activo = 1 AND i.IDS = $idSucursal")->fetchAll(PDO::FETCH_ASSOC);
    
    $clientes = $pdo->query("SELECT IDC, Nombre, Telefono FROM `{$prefijoTablas}Clientes` WHERE EstadoCliente = 'Activo' ORDER BY Nombre ASC LIMIT 100")->fetchAll(PDO::FETCH_ASSOC);

    $qImp = $pdo->query("SELECT ID_Config FROM `{$prefijoTablas}Configuracion_Impresoras` WHERE Activo = 1 LIMIT 1");
    $fImp = $qImp->fetch(PDO::FETCH_ASSOC);
    $idImpresoraBackup = $fImp['ID_Config'] ?? 1;

} catch (PDOException $e) { die("Error de BD: " . $e->getMessage()); }

$jsonProd = json_encode($productos);
$jsonCli = json_encode($clientes);

include_once('../librerias/Modulos/Impresora.php'); 
?>

<style>
    :root { --pos-accent: #f26522; --pos-border: #e3e6f0; }
    .pos-wrapper { background: #f8f9fc; height: calc(100vh - 85px); display: flex; overflow: hidden; margin: -20px; }
    .catalog-area { flex: 1; display: flex; flex-direction: column; background: #f4f7fa; border-right: 1px solid var(--pos-border); }
    .catalog-scroll { flex: 1; overflow-y: auto; padding: 15px; }
    #posGrid { display: flex; flex-wrap: wrap; align-content: flex-start; min-height: 100%; }
    .prod-card-h { 
        display: flex; align-items: center; background: #fff; border-radius: 8px; margin-bottom: 12px; 
        transition: 0.2s; cursor: pointer; border: 1px solid #fff; box-shadow: 0 2px 5px rgba(0,0,0,0.05); padding: 8px; height: 95px; width: 100%;
    }
    .prod-card-h:hover { border-color: var(--pos-accent); transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
    .prod-card-h img { width: 70px; height: 70px; object-fit: contain; background: #f8f9fa; border-radius: 5px; }
    .prod-info { padding: 0 15px; flex: 1; min-width: 0; }
    .prod-info h6 { font-size: 0.9rem; font-weight: 700; color: #333; margin: 0; }
    .prod-price { text-align: right; min-width: 100px; color: var(--pos-accent); font-weight: 800; font-size: 1rem; }
    .cart-sidebar { width: 420px; display: flex; flex-direction: column; background: #fff; border-left: 1px solid var(--pos-border); }
    .cart-list { flex: 1; overflow-y: auto; padding: 15px; }
    .cart-item { border-bottom: 1px solid #f1f3f9; padding: 12px 0; }
    .cart-footer { padding: 25px; border-top: 2px solid #f1f3f9; background: #fff; }
    .cli-results { position: absolute; top: 100%; left: 0; right: 0; background: white; z-index: 1050; border: 1px solid #ddd; display: none; max-height: 200px; overflow-y: auto; }
    .cli-item { padding: 10px; border-bottom: 1px solid #eee; cursor: pointer; }
    .cli-item:hover { background: #f0f7ff; }
    .input-cart-sm { width: 70px; height: 28px; font-size: 0.8rem; text-align: center; border-radius: 4px; border: 1px solid #ddd; }
</style>

<div class="pos-wrapper">
    <div class="catalog-area">
        <div class="p-3 bg-white border-bottom shadow-sm d-flex align-items-center">
            <input type="text" id="posSearch" class="form-control form-control-lg border-0 bg-light" placeholder="Escanear o buscar producto..." autofocus>
            <div class="ml-3" style="min-width: 180px;">
                <span class="badge badge-dark p-2 w-100" style="font-size: 0.9rem;">FOLIO: <b id="lblFolioDisplay"><?php echo $folioTemp; ?></b></span>
            </div>
        </div>
        <div class="catalog-scroll">
            <div id="posGrid" class="row no-gutters"></div>
        </div>
    </div>

    <div class="cart-sidebar">
        <div class="p-3 border-bottom bg-light">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <label class="small font-weight-bold m-0">CLIENTE</label>
                <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modalCli"><i class="feather icon-plus"></i></button>
            </div>
            <div class="position-relative mb-2">
                <input type="text" id="busCli" class="form-control" placeholder="Buscar por nombre o tel..." autocomplete="off">
                <div id="resCli" class="cli-results shadow"></div>
                <div id="cliSelected" class="alert alert-primary mt-2 d-none mb-0 p-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <small id="cliNombre" class="font-weight-bold"></small>
                        <button class="btn btn-sm p-0 text-danger" onclick="posEngine.clearClient()">&times;</button>
                    </div>
                </div>
            </div>
            <label class="small font-weight-bold m-0 mt-2">LISTA DE PRECIOS</label>
            <select id="selPriceType" class="form-control form-control-sm mt-1" onchange="posEngine.changePriceType()">
                <option value="precio_venta">Precio Público</option>
                <option value="precio_mayoreo">Precio Mayoreo</option>
                <option value="precio_web">Precio Web</option>
            </select>
        </div>

        <div class="cart-list" id="cartBody">
            <div class="text-center py-5 opacity-25" id="msgEmpty"><i class="feather icon-shopping-cart fa-3x"></i><br>CARRITO VACÍO</div>
        </div>

        <div class="cart-footer">
            <div class="d-flex justify-content-between mb-1 text-muted"><span>Subtotal:</span><span id="lblSub">$0.00</span></div>
            <div class="d-flex justify-content-between mb-1 text-danger"><span>Desc. Total:</span><span id="lblDesc">$0.00</span></div>
            <div class="d-flex justify-content-between mb-1 text-info"><span>IVA (16%):</span><span id="lblIva">$0.00</span></div>
            <div class="custom-control custom-switch my-3">
                <input type="checkbox" class="custom-control-input" id="chkFactura" onchange="posEngine.renderCart()">
                <label class="custom-control-label font-weight-bold" for="chkFactura">FACTURAR VENTA</label>
            </div>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="font-weight-bold m-0">TOTAL:</h4>
                <h3 class="font-weight-bold text-primary m-0" id="lblTotal">$0.00</h3>
            </div>
            <button class="btn btn-success btn-block btn-lg py-3 shadow font-weight-bold" onclick="posEngine.preCheckout()">FINALIZAR VENTA</button>
        </div>
    </div>
</div>

<div class="modal fade" id="modalSeries" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content border-0">
            <div class="modal-header bg-dark text-white"><h6 class="modal-title">ELEGIR SERIES</h6></div>
            <div class="modal-body">
                <p class="small text-muted">Seleccionar <b id="serCount"></b> para:<br><strong id="lblSerProd"></strong></p>
                <div id="serList" class="row no-gutters"></div>
            </div>
            <div class="modal-footer"><button class="btn btn-primary btn-block" onclick="posEngine.confirmSeries()">AGREGAR PRODUCTO</button></div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalCli" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content p-4">
            <h5 class="font-weight-bold mb-3">NUEVO CLIENTE</h5>
            <input type="text" id="nCliNom" class="form-control mb-2" placeholder="Nombre">
            <input type="number" id="nCliTel" class="form-control mb-3" placeholder="Teléfono">
            <button class="btn btn-primary btn-block" onclick="posEngine.saveClient()">GUARDAR</button>
        </div>
    </div>
</div>

<script>
const posEngine = (function() {
    const CFG = { 
        db: '<?php echo $dbName; ?>', px: '<?php echo $prefijoTablas; ?>', 
        ids: '<?php echo $idSucursal; ?>', idu: '<?php echo $idUsuario; ?>', 
        fol: '<?php echo $folioTemp; ?>', vend: '<?php echo $vendedor; ?>',
        defImp: '<?php echo $idImpresoraBackup; ?>'
    };
    
    let products = <?php echo $jsonProd; ?>, clients = <?php echo $jsonCli; ?>, cart = [], clientSelected = null, tempP = null;

    const money = n => new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' }).format(n);
    const cleanNum = str => parseFloat(str.replace(/[^0-9.-]+/g, "")) || 0;

    const api = async (file, sql) => {
        const fd = new FormData(); fd.append('sql', sql); fd.append('db', CFG.db);
        return fetch(`../librerias/AJAX/${file}`, { method: 'POST', body: fd }).then(r => r.json());
    };

    return {
        init: function() {
            this.renderGrid(products);
            document.getElementById('posSearch').onkeyup = (e) => {
                const v = e.target.value.trim();
                if(e.key === "Enter" && v !== "") { this.handleScanner(v); e.target.value = ""; return; }
                this.renderGrid(products.filter(p => p.nombre.toLowerCase().includes(v.toLowerCase()) || p.sku.toLowerCase().includes(v.toLowerCase())));
            };
            document.getElementById('busCli').onkeyup = (e) => {
                const v = e.target.value.toLowerCase();
                const box = document.getElementById('resCli');
                if(v.length < 3) { box.style.display = 'none'; return; }
                const filtered = clients.filter(c => c.Nombre.toLowerCase().includes(v) || (c.Telefono && c.Telefono.includes(v)));
                box.innerHTML = '';
                if(filtered.length > 0) {
                    box.style.display = 'block';
                    filtered.forEach(c => {
                        const d = document.createElement('div'); d.className = 'cli-item';
                        d.innerHTML = `<b>${c.Nombre}</b><br><small>${c.Telefono || ''}</small>`;
                        d.onclick = () => { clientSelected = c; this.selectClient(); };
                        box.appendChild(d);
                    });
                }
            };
        },

        handleScanner: async function(term) {
            const r = await api('Select.php', `SELECT SKU, Serie FROM \`${CFG.px}Productos_Series\` WHERE Serie = '${term}' AND Estado = 'DISPONIBLE' LIMIT 1`);
            if(r.data && r.data.length > 0) {
                const pS = products.find(x => x.sku === r.data[0].SKU);
                if(pS) this.addCart(pS, 1, r.data[0].Serie);
            } else {
                const pX = products.find(x => x.sku === term || x.codigo_barras === term);
                if(pX) this.checkItem(pX.sku);
            }
        },

        renderGrid: function(list) {
            const grid = document.getElementById('posGrid'); if(!grid) return;
            grid.innerHTML = ''; 
            list.forEach(p => {
                const stock = parseFloat(p.existencia);
                const pType = document.getElementById('selPriceType').value;
                const price = parseFloat(p[pType]);
                const img = (p.imagen && p.imagen.length > 5) ? p.imagen : 'https://cdn-icons-png.flaticon.com/512/107/107831.png';
                grid.insertAdjacentHTML('beforeend', `<div class="col-xl-4 col-lg-6 col-md-12 px-2"><div class="prod-card-h" onclick="posEngine.checkItem('${p.sku}')" style="${stock <= 0 ? 'opacity:0.4' : ''}"><img src="${img}" onerror="this.src='https://cdn-icons-png.flaticon.com/512/107/107831.png'"><div class="prod-info"><h6 class="text-truncate">${p.nombre}</h6><small class="text-muted">SKU: ${p.sku}</small><br><span class="badge ${stock > 0 ? 'badge-light text-success' : 'badge-danger'}">Stock: ${stock}</span></div><div class="prod-price">${money(price)}</div></div></div>`);
            });
        },

        changePriceType: function() {
            const pType = document.getElementById('selPriceType').value;
            cart.forEach(item => {
                const pData = products.find(x => x.sku === item.sku);
                item.price = parseFloat(pData[pType]);
            });
            this.renderGrid(products);
            this.renderCart();
        },

        updateDiscount: function(idx, val) {
            const item = cart[idx];
            const discount = parseFloat(val) || 0;
            // VALIDACIÓN: Descuento nunca mayor al costo de compra
            if(discount > item.cost) {
                alert(`¡Alerta de Seguridad! El descuento (${money(discount)}) no puede ser mayor al costo de compra del producto (${money(item.cost)}).`);
                document.getElementById(`desc-${idx}`).value = 0;
                item.discount = 0;
            } else {
                item.discount = discount;
            }
            this.renderCart();
        },

        addCart: function(p, qty, serie) {
            const pType = document.getElementById('selPriceType').value;
            const exist = cart.find(i => i.sku === p.sku);
            if(exist) {
                if(serie) {
                    if(exist.series.includes(serie)) return alert("Serie ya en el carrito");
                    exist.series.push(serie);
                }
                exist.qty += qty;
            } else {
                cart.push({ 
                    sku: p.sku, 
                    nombre: p.nombre, 
                    price: parseFloat(p[pType]), 
                    cost: parseFloat(p.costo_promedio),
                    qty: qty, 
                    discount: 0,
                    series: serie ? [serie] : [] 
                });
            }
            this.renderCart();
        },

        renderCart: function() {
            const body = document.getElementById('cartBody'); if(!body) return;
            body.innerHTML = '';
            let sub = 0; let totalDesc = 0;
            cart.forEach((i, idx) => {
                const baseRow = i.price * i.qty;
                const rowDesc = i.discount * i.qty;
                const totalRow = baseRow - rowDesc;
                
                sub += baseRow;
                totalDesc += rowDesc;

                body.innerHTML += `
                <div class="cart-item">
                    <div class="d-flex justify-content-between align-items-start pr-2">
                        <div style="flex:1">
                            <div class="small font-weight-bold">${i.nombre}</div>
                            ${i.series.length ? `<small class="text-primary d-block">SN: ${i.series.join(', ')}</small>` : ''}
                            <div class="d-flex align-items-center mt-1">
                                <small class="mr-2 text-muted">Desc/u:</small>
                                <input type="number" id="desc-${idx}" class="input-cart-sm" value="${i.discount}" onchange="posEngine.updateDiscount(${idx}, this.value)">
                            </div>
                        </div>
                        <div class="text-right ml-2">
                            <span class="badge badge-light">x${i.qty}</span><br>
                            <span class="font-weight-bold" style="font-size:0.85rem">${money(totalRow)}</span>
                        </div>
                        <button class="btn btn-link text-danger p-0 ml-2" onclick="posEngine.remove(${idx})">&times;</button>
                    </div>
                </div>`;
            });

            const msg = document.getElementById('msgEmpty'); if(msg) msg.style.display = cart.length ? 'none' : 'block';
            const fact = document.getElementById('chkFactura').checked;
            const subNeto = sub - totalDesc;
            const iva = fact ? subNeto * 0.16 : 0;
            const total = subNeto + iva;

            if(document.getElementById('lblSub')) document.getElementById('lblSub').innerText = money(sub);
            if(document.getElementById('lblDesc')) document.getElementById('lblDesc').innerText = money(totalDesc);
            if(document.getElementById('lblIva')) document.getElementById('lblIva').innerText = money(iva);
            if(document.getElementById('lblTotal')) document.getElementById('lblTotal').innerText = money(total);
        },

        checkItem: async function(sku) {
            const p = products.find(x => x.sku === sku); if(!p || parseFloat(p.existencia) <= 0) return;
            const r = await api('Select.php', `SELECT Serie FROM \`${CFG.px}Productos_Series\` WHERE SKU = '${sku}' AND Estado = 'DISPONIBLE'`);
            if(r.data && r.data.length > 0) {
                tempP = p; const cant = prompt("¿Cantidad?", 1); if(!cant || isNaN(cant) || cant < 1) return;
                tempP.qtyTarget = parseInt(cant);
                const list = document.getElementById('serList'); list.innerHTML = '';
                r.data.forEach(s => list.innerHTML += `<div class="col-6 p-1"><button class="btn btn-outline-secondary btn-block btn-sm s-btn" onclick="this.classList.toggle('active'); this.classList.toggle('btn-primary');">${s.Serie}</button></div>`);
                document.getElementById('serCount').innerText = tempP.qtyTarget;
                document.getElementById('lblSerProd').innerText = p.nombre; $('#modalSeries').modal('show');
            } else { this.addCart(p, 1, null); }
        },

        confirmSeries: function() {
            const sel = document.querySelectorAll('.s-btn.active');
            if(sel.length != tempP.qtyTarget) return alert(`Selecciona ${tempP.qtyTarget} series`);
            sel.forEach(s => this.addCart(tempP, 1, s.innerText)); $('#modalSeries').modal('hide');
        },

        selectClient: function() { document.getElementById('cliNombre').innerText = clientSelected.Nombre; document.getElementById('cliSelected').classList.remove('d-none'); document.getElementById('busCli').style.display = 'none'; document.getElementById('resCli').style.display = 'none'; },
        clearClient: function() { clientSelected = null; document.getElementById('cliSelected').classList.add('d-none'); document.getElementById('busCli').style.display = 'block'; document.getElementById('busCli').value = ''; },
        remove: function(idx) { cart.splice(idx,1); this.renderCart(); },

        saveClient: async function() {
            const n = document.getElementById('nCliNom').value, t = document.getElementById('nCliTel').value; if(!n || !t) return;
            const r = await api('Execute.php', `INSERT INTO \`${CFG.px}Clientes\` (Nombre, Telefono, EstadoCliente, IDU) VALUES ('${n}', '${t}', 'Activo', 'CLI-${Date.now()}')`);
            if(r.last_id) { clients.push({IDC: r.last_id, Nombre: n, Telefono: t}); clientSelected = clients[clients.length-1]; this.selectClient(); $('#modalCli').modal('hide'); }
        },

        preCheckout: function() { if(!cart.length) return; if(confirm(`¿Finalizar venta por ${document.getElementById('lblTotal').innerText}?`)) this.exec(); },
        
        exec: async function() {
            const subTotal = cleanNum(document.getElementById('lblSub').innerText);
            const totalDesc = cleanNum(document.getElementById('lblDesc').innerText);
            const subNeto = subTotal - totalDesc;
            const total = cleanNum(document.getElementById('lblTotal').innerText);
            
            const r = await api('Execute.php', `INSERT INTO \`${CFG.px}Ventas_Cabecera\` (Folio, IDC_Cliente, IDU_Usuario, IDS_Sucursal, Subtotal, Descuento, Total) VALUES ('${CFG.fol}', ${clientSelected?clientSelected.IDC:0}, '${CFG.idu}', ${CFG.ids}, ${subNeto}, ${totalDesc}, ${total})`);
            
            if(r.last_id) {
                const idVentaRef = r.last_id;
                for(const i of cart) {
                    const priceFinal = i.price - i.discount;
                    await api('Execute.php', `INSERT INTO \`${CFG.px}Ventas_Detalle\` (ID_Venta, SKU, Nombre_Producto, Cantidad, Precio_Venta, Costo_Original, Subtotal) VALUES (${idVentaRef}, '${i.sku}', '${i.nombre}', ${i.qty}, ${priceFinal}, ${i.cost}, ${priceFinal * i.qty})`);
                    await api('Execute.php', `UPDATE \`${CFG.px}Productos_Inventario\` SET existencia = existencia - ${i.qty} WHERE sku = '${i.sku}' AND IDS = ${CFG.ids}`);
                    for(const s of i.series) await api('Execute.php', `UPDATE \`${CFG.px}Productos_Series\` SET Estado = 'VENDIDO' WHERE Serie = '${s}' AND SKU = '${i.sku}'`);
                }

                const selImp = document.getElementById('pe-select-config');
                const idImpresora = (selImp && selImp.value) ? selImp.value : CFG.defImp;

                const saleInfo = { 
                    folio: CFG.fol, 
                    cliente: clientSelected ? clientSelected.Nombre : 'Público General', 
                    telefono: clientSelected ? clientSelected.Telefono : 'N/A', 
                    vendedor: CFG.vend, 
                    items: cart, 
                    total, 
                    sub: subNeto, 
                    descuento: totalDesc,
                    iva: (total - subNeto).toFixed(2) 
                };
                
                const jsonStr = JSON.stringify(saleInfo).replace(/'/g, "\\'");
                const sqlDoc = `INSERT INTO \`${CFG.px}Documentos_Generados\` (UUID_Unico, Modulo_Origen, ID_Referencia, ID_Config_Impresora, Contenido_JSON, Estado) VALUES ('${CFG.fol}', 'PuntoVenta', ${idVentaRef}, ${idImpresora}, '${jsonStr}', 'PENDIENTE')`;
                
                await api('Execute.php', sqlDoc);

                if (typeof PrintEngine !== 'undefined') PrintEngine.show(saleInfo);
                else location.reload();
            }
        }
    };
})();
posEngine.init();
</script>