<?php
// =============================================================================
// CAPA 1: LOGICA DE BACKEND (Basado en Schema: #-GPS_Equipos)
// =============================================================================
if (session_status() === PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die("Acceso Denegado");
}

$DB_NAME = "MS_Datos"; 
$IDC_EMPRESA = $_SESSION['IDUg'] ?? 1; 
$TABLA = "$IDC_EMPRESA-GPS_Equipos"; // Nombre real en BD: #-GPS_Equipos
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    .card-metric { border: none; border-radius: 12px; background: white; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
    .table-ui thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background: #f8f9fa; border-bottom: 2px solid #e9ecef; padding: 15px; }
    .status-pill { padding: 4px 12px; border-radius: 20px; font-size: 11px; font-weight: bold; color: white; }
    .bg-activo { background-color: #2ed8b6; }
    .bg-inactivo { background-color: #ffb64d; }
    .bg-baja { background-color: #ff5370; }
    .imei-font { font-family: 'Courier New', Courier, monospace; font-weight: bold; letter-spacing: 1px; }
</style>

<div class="container-fluid p-3">
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card card-metric p-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div><small class="text-muted font-weight-bold">EQUIPOS GPS</small><h3 class="mb-0 font-weight-bold" id="kpi_total">0</h3></div>
                    <div class="text-primary"><i class="fas fa-satellite fa-2x"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-9 text-right">
            <button class="btn btn-dark shadow-lg mt-2" onclick="abrirModal()">
                <i class="fas fa-plus-circle mr-1"></i> Registrar Hardware
            </button>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-header bg-white py-3">
            <h5 class="mb-0 font-weight-bold text-dark"><i class="fas fa-microchip mr-2 text-primary"></i>Gestión de Inventario GPS</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle table-ui mb-0">
                <thead>
                    <tr>
                        <th class="text-center">IDG</th>
                        <th>IDP (Plataforma)</th>
                        <th>Identidad (IMEI)</th>
                        <th>Comunicación (Chip)</th>
                        <th>Operador</th>
                        <th class="text-center">Estado</th>
                        <th class="text-right pr-4">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tabla_body"></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEquipo" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog">
        <div class="modal-content border-0">
            <div class="modal-header bg-dark text-white">
                <h5 class="modal-title font-weight-bold">Ficha Técnica de Equipo</h5>
                <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body p-4 bg-light">
                <form id="formEquipo">
                    <input type="hidden" id="IDG"> <div class="row">
                        <div class="col-md-12 form-group">
                            <label class="font-weight-bold">IMEI (Hardware) *</label>
                            <input type="text" class="form-control" id="imei" required placeholder="15-20 dígitos únicos">
                        </div>
                        <div class="col-md-6 form-group">
                            <label class="font-weight-bold">IDP (Link Catálogo) *</label>
                            <input type="number" class="form-control" id="IDP" required placeholder="Referencia de Producto">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Teléfono del Chip</label>
                            <input type="text" class="form-control" id="chip_telefono">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Operador</label>
                            <select class="form-control" id="operador">
                                <option value="Telcel">Telcel</option>
                                <option value="AT&T">AT&T</option>
                                <option value="Movistar">Movistar</option>
                                <option value="Multi-Carrier">Multi-Carrier</option>
                            </select>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Fecha Instalación</label>
                            <input type="date" class="form-control" id="fecha_instalacion">
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Estado del Equipo</label>
                            <select class="form-control" id="estado">
                                <option value="Activo">Activo (En Campo)</option>
                                <option value="Inactivo">Inactivo (Almacén)</option>
                                <option value="Baja">Baja (Dañado)</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer border-0">
                <button type="button" class="btn btn-primary btn-block font-weight-bold py-2 shadow" onclick="guardarEquipo()">GUARDAR REGISTRO</button>
            </div>
        </div>
    </div>
</div>

<script>
const DB = "<?php echo $DB_NAME; ?>";
const TABLA = "<?php echo $TABLA; ?>";

document.addEventListener('DOMContentLoaded', () => { window.listarEquipos(); });

// --- LECTURA ---
window.listarEquipos = function() {
    const sql = `SELECT * FROM \`${TABLA}\` ORDER BY IDG DESC`;
    
    fetch('../librerias/AJAX/Select.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB}`
    })
    .then(r => r.json())
    .then(res => {
        const d = res.data || (Array.isArray(res) ? res : []);
        const tbody = document.getElementById('tabla_body');
        tbody.innerHTML = '';
        let tot = 0;

        d.forEach(row => {
            tot++;
            const statusClass = `bg-${row.estado.toLowerCase()}`;
            tbody.innerHTML += `
                <tr>
                    <td class="text-center font-weight-bold text-muted">${row.IDG}</td>
                    <td class="text-primary font-weight-bold text-center">${row.IDP}</td>
                    <td class="imei-font">${row.imei}</td>
                    <td>${row.chip_telefono || 'S/N'}</td>
                    <td>${row.operador}</td>
                    <td class="text-center"><span class="status-pill ${statusClass}">${row.estado}</span></td>
                    <td class="text-right pr-4">
                        <button class="btn btn-sm btn-light border" onclick='editarEquipo(${JSON.stringify(row)})'>
                            <i class="fas fa-edit text-primary"></i>
                        </button>
                    </td>
                </tr>`;
        });
        document.getElementById('kpi_total').innerText = tot;
    });
};

// --- ESCRITURA (SQL ACTUALIZADO A SCHEMA) ---
window.guardarEquipo = async function() {
    const id = document.getElementById('IDG').value;
    const imei = document.getElementById('imei').value.trim();
    const idp = document.getElementById('IDP').value;
    
    if(!imei || !idp) return Swal.fire('Faltan datos', 'IMEI e IDP son obligatorios', 'warning');

    const safe = (s) => s ? s.replace(/'/g, "\\'") : '';
    const valFecha = document.getElementById('fecha_instalacion').value;
    const sqlFecha = valFecha ? `'${valFecha}'` : 'NULL';

    const d = {
        idp: idp,
        imei: safe(imei),
        chip: safe(document.getElementById('chip_telefono').value),
        oper: document.getElementById('operador').value,
        esta: document.getElementById('estado').value
    };

    let sql = "";
    if(id) {
        // UPDATE (IDG ya existe)
        sql = `UPDATE \`${TABLA}\` SET 
               IDP=${d.idp}, imei='${d.imei}', chip_telefono='${d.chip}', 
               operador='${d.oper}', fecha_instalacion=${sqlFecha}, estado='${d.esta}' 
               WHERE IDG=${id}`;
    } else {
        // INSERT (IDG es AUTO_INCREMENT, no se envía)
        sql = `INSERT INTO \`${TABLA}\` (IDP, imei, chip_telefono, operador, fecha_instalacion, estado) 
               VALUES (${d.idp}, '${d.imei}', '${d.chip}', '${d.oper}', ${sqlFecha}, '${d.esta}')`;
    }

    // Depuración en consola para ver el Query real
    console.log("Query Ejecutado:", sql);

    fetch('../librerias/AJAX/Execute.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `sql=${encodeURIComponent(sql)}&db=${DB}`
    })
    .then(r => r.json())
    .then(res => {
        const exito = (res.status && (res.status.toUpperCase() === 'OK' || res.status.toLowerCase() === 'success'));

        if(exito) {
            Swal.fire({ icon: 'success', title: 'Hardware Sincronizado', timer: 1500, showConfirmButton: false });
            $('#modalEquipo').modal('hide');
            window.listarEquipos();
        } else {
            Swal.fire('Error de Guardado', res.mensaje || 'Error de sintaxis o IMEI duplicado', 'error');
        }
    })
    .catch(err => Swal.fire('Error', 'Fallo de conexión técnica', 'error'));
};

window.abrirModal = () => { 
    document.getElementById('formEquipo').reset(); 
    document.getElementById('IDG').value = ''; 
    $('#modalEquipo').modal('show'); 
};

window.editarEquipo = (row) => {
    document.getElementById('IDG').value = row.IDG;
    document.getElementById('IDP').value = row.IDP;
    document.getElementById('imei').value = row.imei;
    document.getElementById('chip_telefono').value = row.chip_telefono;
    document.getElementById('operador').value = row.operador;
    document.getElementById('fecha_instalacion').value = row.fecha_instalacion;
    document.getElementById('estado').value = row.estado;
    $('#modalEquipo').modal('show');
};
</script>