<?php
// 1. SEGURIDAD
session_start();
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') { die("Acceso Denegado"); }

// Contexto de Base de Datos
$nombre_bd = "MS_Datos";
$prefijo = isset($IDU) ? $IDU : ($_SESSION['IDU'] ?? '101'); 
$tb_config = $prefijo . "-Configuracion_Impresoras"; 
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Courier+Prime&family=Roboto:wght@400;700&display=swap" rel="stylesheet">

<style>
    body { background-color: #f3f4f6; font-family: 'Segoe UI', sans-serif; }
    
    /* --- LISTADO LATERAL --- */
    .card-profile { 
        border: none; border-radius: 12px; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.05); 
        transition: all 0.2s; cursor: pointer; 
        border-left: 5px solid transparent; 
        background: white;
    }
    .card-profile:hover { transform: translateY(-3px); box-shadow: 0 10px 15px rgba(0,0,0,0.1); }
    .card-profile.active { border-left-color: #3b82f6; background: #f0f9ff; }
    
    /* --- VISTA PREVIA --- */
    .preview-bg {
        background-color: #525659;
        padding: 40px;
        border-radius: 8px;
        overflow: auto;
        height: 650px;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        border: 1px solid #dee2e6;
    }

    .paper {
        background: white;
        box-shadow: 0 0 20px rgba(0,0,0,0.5);
        padding: 15px;
        color: #000;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        margin-bottom: 40px;
    }

    /* TAMAÑOS */
    .paper.p-58mm { width: 58mm; min-height: 200px; font-family: 'Courier Prime', monospace; font-size: 10px; }
    .paper.p-80mm { width: 80mm; min-height: 250px; font-family: 'Courier Prime', monospace; font-size: 12px; }
    .paper.p-a5   { width: 148mm; height: 210mm; font-family: 'Roboto', sans-serif; font-size: 12px; }
    .paper.p-a4   { width: 210mm; height: 297mm; font-family: 'Roboto', sans-serif; font-size: 14px; }

    /* ORIENTACIÓN */
    .paper.landscape.p-a5 { width: 210mm; height: 148mm; }
    .paper.landscape.p-a4 { width: 297mm; height: 210mm; }

    /* ELEMENTOS INTERNOS */
    .ticket-logo { max-width: 80%; margin: 0 auto 10px auto; display: block; filter: grayscale(100%); }
    .paper.p-a4 .ticket-logo, .paper.p-a5 .ticket-logo { filter: none; max-width: 150px; margin: 0; }

    .ticket-header { text-align: center; margin-bottom: 15px; white-space: pre-wrap; line-height: 1.2; }
    .paper.p-a4 .ticket-header { text-align: left; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }

    .ticket-body { 
        border-top: 1px dashed #000; border-bottom: 1px dashed #000; 
        padding: 20px 0; margin: 10px 0; min-height: 100px; 
        display: flex; align-items: center; justify-content: center; 
        color: #999; text-transform: uppercase; font-weight: bold; background: #fafafa;
    }
    .paper.p-a4 .ticket-body { border: 1px solid #ddd; background: #fff; height: 400px; align-items: flex-start; padding: 20px; }

    .ticket-footer { text-align: center; margin-top: 15px; font-size: 0.9em; white-space: pre-wrap; }
    .paper.p-a4 .ticket-footer { position: absolute; bottom: 20px; width: 90%; text-align: center; border-top: 1px solid #ccc; padding-top: 10px; }
</style>

<div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="font-weight-bold text-dark mb-0"><i class="fas fa-print mr-2"></i>Configuración de Impresoras</h3>
            <p class="text-muted small mb-0">Define formatos: Física, Web o PDF.</p>
        </div>
        <button class="btn btn-primary font-weight-bold shadow-sm" onclick="nuevoPerfil()">
            <i class="fas fa-plus mr-2"></i>Nuevo Perfil
        </button>

    </div>

    <div class="row">
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white font-weight-bold text-uppercase small text-muted border-0 pb-0">
                    Perfiles Disponibles
                </div>
                <div class="card-body p-3" id="lista_perfiles" style="max-height: 700px; overflow-y: auto;">
                    <div class="text-center py-5 text-muted"><i class="fas fa-spinner fa-spin"></i> Cargando...</div>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card shadow-sm border-0" id="panel_editor" style="display:none;">
                <div class="card-header bg-white border-bottom-0 pt-4 pb-0 d-flex justify-content-between align-items-center">
                    <h5 class="font-weight-bold text-primary mb-0" id="titulo_editor">Editar Perfil</h5>
                    <button class="btn btn-outline-danger btn-sm rounded-pill" onclick="eliminarPerfil()" title="Eliminar"><i class="fas fa-trash"></i></button>
                </div>
                
                <div class="card-body">
                    <form id="formConfig">
                        <input type="hidden" id="ID_Config">
                        
                        <div class="bg-light p-3 rounded mb-3 border">
                            <div class="row">
                                <div class="col-md-8 mb-2">
                                    <label class="small font-weight-bold text-dark">Nombre del Perfil (Visual)</label>
                                    <input type="text" class="form-control font-weight-bold" id="Nombre_Perfil" placeholder="Ej: Ticket Caja Principal">
                                </div>
                                <div class="col-md-4 mb-2">
                                    <label class="small font-weight-bold">Método de Impresión</label>
                                    <select class="form-control" id="Metodo_Salida" onchange="toggleColaInput()">
                                        <option value="Fisica">🖨️ Impresora Física (App)</option>
                                        <option value="Web">🌐 Navegador Web</option>
                                        <option value="PDF">📄 Descargar PDF</option>
                                    </select>
                                </div>
                                <div class="col-md-12 mt-2" id="div_cola_sistema">
                                    <label class="small font-weight-bold text-danger"><i class="fas fa-laptop-code mr-1"></i>Nombre de Cola (Sistema/PC)</label>
                                    <input type="text" class="form-control" id="Nombre_Cola_Sistema" placeholder="Ej: EPSON_TM_T20II">
                                    <small class="text-muted" style="font-size: 0.75em;">Debe coincidir EXACTAMENTE con el nombre en Windows/Linux para que el Agente la detecte.</small>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="small font-weight-bold">Tamaño de Papel</label>
                                <select class="form-control" id="Tipo_Papel" onchange="actualizarPreview()">
                                    <option value="58mm">Ticket Térmico 58mm</option>
                                    <option value="80mm">Ticket Térmico 80mm (Estándar)</option>
                                    <option value="A5">Hoja A5 (Media Carta)</option>
                                    <option value="A4">Hoja A4 (Carta Normal)</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="small font-weight-bold">Orientación</label>
                                <select class="form-control" id="Orientacion" onchange="actualizarPreview()">
                                    <option value="Portrait">Vertical (Portrait)</option>
                                    <option value="Landscape">Horizontal (Landscape)</option>
                                </select>
                            </div>
                        </div>

                        <ul class="nav nav-tabs mb-3" id="tabPrint" role="tablist">
                            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#tab_contenido"><i class="fas fa-pen mr-2"></i>Diseño</a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab_preview"><i class="fas fa-eye mr-2"></i>Vista Previa</a></li>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="tab_contenido">
                                <div class="row">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label class="small font-weight-bold">Logo (Imagen)</label>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="inputLogo" accept="image/*" onchange="convertirLogo()">
                                                <label class="custom-file-label" for="inputLogo" data-browse="Buscar">Seleccionar...</label>
                                            </div>
                                            <input type="hidden" id="Logo_Base64">
                                            
                                            <div class="mt-2 text-center border rounded p-2 bg-white d-flex align-items-center justify-content-between">
                                                <div id="preview_box">
                                                    <img id="img_preview_mini" src="" style="max-height: 40px; display: none;">
                                                    <span id="txt_no_logo" class="small text-muted">Sin logo</span>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="borrarLogo()" id="btn_borrar_logo" style="display:none;" title="Quitar logo"><i class="fas fa-times"></i></button>
                                            </div>
                                            <small class="text-muted d-block mt-1">Preferible imágenes B/N para tickets.</small>
                                        </div>
                                    </div>
                                    <div class="col-md-7">
                                        <div class="form-group">
                                            <label class="small font-weight-bold">Cabecera</label>
                                            <textarea class="form-control font-monospace" id="Cabecera_Texto" rows="4" placeholder="Nombre de la Tienda&#10;RFC: XAXX010101000&#10;Dirección..." onkeyup="actualizarPreview()"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label class="small font-weight-bold">Pie de Página</label>
                                            <textarea class="form-control font-monospace" id="Pie_Pagina_Texto" rows="4" placeholder="¡Gracias por su compra!&#10;Wifi: Clave123" onkeyup="actualizarPreview()"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="tab_preview">
                                <div class="preview-bg">
                                    <div id="hoja_papel" class="paper p-80mm">
                                        <img id="logo_render" class="ticket-logo" src="" style="display:none;">
                                        <div id="header_render" class="ticket-header">DATOS CABECERA</div>
                                        <div class="ticket-body">
                                            <div class="text-center">
                                                <i class="fas fa-shopping-cart fa-2x mb-2 text-muted"></i><br>
                                                [ DETALLE DE VENTA ]<br>
                                                <small>(Generado dinámicamente)</small>
                                            </div>
                                        </div>
                                        <div id="footer_render" class="ticket-footer">DATOS PIE DE PÁGINA</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="border-top pt-3 text-right mt-3">
                             <button type="button" class="btn btn-secondary mr-2" onclick="location.reload()">Cancelar</button>
                             <button type="button" class="btn btn-success font-weight-bold px-4 shadow" onclick="guardarPerfil()">
                                <i class="fas fa-save mr-2"></i>Guardar Configuración
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div id="panel_vacio" class="text-center py-5 mt-5">
                <div class="mb-3 text-muted"><i class="fas fa-print fa-4x opacity-50"></i></div>
                <h4 class="text-dark font-weight-bold">Selecciona un Perfil</h4>
                <p class="text-muted">Configura tus impresoras físicas, web o PDF.</p>
                <button class="btn btn-primary mt-3" onclick="nuevoPerfil()">Crear Perfil</button>
            </div>
        </div>
    </div>
</div>

<script>
    const DB = "<?php echo $nombre_bd; ?>";
    const TB = "<?php echo $tb_config; ?>";
    const safe = (str) => str ? String(str).replace(/'/g, "\\'") : '';

    document.addEventListener('DOMContentLoaded', () => {
        listarPerfiles();
    });

    // --- INTERFAZ DINÁMICA ---
    function toggleColaInput() {
        const metodo = document.getElementById('Metodo_Salida').value;
        const divCola = document.getElementById('div_cola_sistema');
        // Solo mostramos el input de Cola si es impresora Física
        if (metodo === 'Fisica') {
            divCola.style.display = 'block';
        } else {
            divCola.style.display = 'none';
        }
    }

    // --- LISTAR ---
    function listarPerfiles() {
        const sql = `SELECT * FROM \`${TB}\` WHERE Activo=1 ORDER BY ID_Config DESC`;
        fetch('../librerias/AJAX/Select.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            const div = document.getElementById('lista_perfiles');
            div.innerHTML = '';
            if(res.data && res.data.length > 0) {
                res.data.forEach(p => {
                    // Icono inteligente según método
                    let icon = 'fa-print'; // Física
                    let badgeColor = 'badge-primary';
                    
                    if(p.Metodo_Salida === 'Web') { icon = 'fa-globe'; badgeColor = 'badge-info'; }
                    if(p.Metodo_Salida === 'PDF') { icon = 'fa-file-pdf'; badgeColor = 'badge-danger'; }

                    div.innerHTML += `
                        <div class="card card-profile p-3 mb-2" onclick='cargarPerfil(${JSON.stringify(p)})'>
                            <div class="d-flex align-items-center">
                                <div class="bg-light rounded p-3 mr-3 text-dark shadow-sm"><i class="fas ${icon} fa-lg"></i></div>
                                <div style="flex:1; overflow:hidden;">
                                    <h6 class="mb-0 font-weight-bold text-dark text-truncate">${p.Nombre_Perfil}</h6>
                                    <div class="small text-muted d-flex justify-content-between mt-1">
                                        <span>${p.Tipo_Papel}</span>
                                        <span class="badge ${badgeColor}">${p.Metodo_Salida || 'Fisica'}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });
            } else {
                div.innerHTML = '<div class="alert alert-light text-center border">No hay perfiles configurados.</div>';
            }
        });
    }

    // --- CRUD ---
    function nuevoPerfil() {
        document.getElementById('panel_vacio').style.display = 'none';
        document.getElementById('panel_editor').style.display = 'block';
        document.getElementById('formConfig').reset();
        document.getElementById('ID_Config').value = '';
        document.getElementById('Logo_Base64').value = '';
        document.getElementById('titulo_editor').innerText = "Creando Nuevo Perfil";
        document.getElementById('Metodo_Salida').value = 'Fisica'; // Default
        
        borrarLogo(); 
        toggleColaInput();
        actualizarPreview();
        $('.nav-tabs a[href="#tab_contenido"]').tab('show'); 
    }

    function cargarPerfil(p) {
        document.getElementById('panel_vacio').style.display = 'none';
        document.getElementById('panel_editor').style.display = 'block';
        
        // Cargar datos
        document.getElementById('ID_Config').value = p.ID_Config;
        document.getElementById('Nombre_Perfil').value = p.Nombre_Perfil;
        document.getElementById('Metodo_Salida').value = p.Metodo_Salida || 'Fisica';
        document.getElementById('Nombre_Cola_Sistema').value = p.Nombre_Cola_Sistema || ''; 
        document.getElementById('Tipo_Papel').value = p.Tipo_Papel;
        document.getElementById('Orientacion').value = p.Orientacion;
        document.getElementById('Cabecera_Texto').value = p.Cabecera_Texto;
        document.getElementById('Pie_Pagina_Texto').value = p.Pie_Pagina_Texto;
        document.getElementById('titulo_editor').innerText = "Editando: " + p.Nombre_Perfil;

        // Cargar Logo
        if(p.Logo_Base64 && p.Logo_Base64.length > 10) {
            document.getElementById('Logo_Base64').value = p.Logo_Base64;
            mostrarMiniaturaLogo(p.Logo_Base64);
        } else {
            borrarLogo();
        }

        toggleColaInput(); // Ajustar visibilidad del input cola
        actualizarPreview();
    }

    function guardarPerfil() {
        const id = document.getElementById('ID_Config').value;
        const nombre = document.getElementById('Nombre_Perfil').value;
        
        if(!nombre) { Swal.fire('Falta Nombre', 'Asigna un nombre al perfil.', 'warning'); return; }

        const data = {
            metodo: document.getElementById('Metodo_Salida').value, // NUEVO
            cola: document.getElementById('Nombre_Cola_Sistema').value, 
            papel: document.getElementById('Tipo_Papel').value,
            orientacion: document.getElementById('Orientacion').value,
            logo: document.getElementById('Logo_Base64').value,
            header: document.getElementById('Cabecera_Texto').value,
            footer: document.getElementById('Pie_Pagina_Texto').value
        };

        let sql = "";
        if(id) {
            sql = `UPDATE \`${TB}\` SET 
                   Nombre_Perfil='${safe(nombre)}', 
                   Metodo_Salida='${safe(data.metodo)}', 
                   Nombre_Cola_Sistema='${safe(data.cola)}', 
                   Tipo_Papel='${data.papel}', 
                   Orientacion='${data.orientacion}', 
                   Logo_Base64='${data.logo}', 
                   Cabecera_Texto='${safe(data.header)}', 
                   Pie_Pagina_Texto='${safe(data.footer)}' 
                   WHERE ID_Config=${id}`;
        } else {
            sql = `INSERT INTO \`${TB}\` 
                   (Nombre_Perfil, Metodo_Salida, Nombre_Cola_Sistema, Tipo_Papel, Orientacion, Logo_Base64, Cabecera_Texto, Pie_Pagina_Texto) 
                   VALUES 
                   ('${safe(nombre)}', '${safe(data.metodo)}', '${safe(data.cola)}', '${data.papel}', '${data.orientacion}', '${data.logo}', '${safe(data.header)}', '${safe(data.footer)}')`;
        }

        fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
        .then(r => r.json()).then(res => {
            if(!res.error) {
                Swal.fire({icon:'success', title:'Guardado', toast:true, position:'top-end', showConfirmButton:false, timer:1500});
                listarPerfiles();
            } else {
                Swal.fire('Error BD', res.error, 'error');
            }
        });
    }

    function eliminarPerfil() {
        const id = document.getElementById('ID_Config').value;
        if(!id) return;
        
        Swal.fire({title:'¿Eliminar?', text:'Se desactivará esta configuración.', icon:'warning', showCancelButton:true, confirmButtonColor:'#d33'}).then(r => {
            if(r.isConfirmed) {
                const sql = `UPDATE \`${TB}\` SET Activo=0 WHERE ID_Config=${id}`;
                fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: `sql=${encodeURIComponent(sql)}&db=${DB}`, headers: {'Content-Type': 'application/x-www-form-urlencoded'} })
                .then(() => {
                    listarPerfiles();
                    document.getElementById('panel_editor').style.display = 'none';
                    document.getElementById('panel_vacio').style.display = 'block';
                });
            }
        });
    }

    // --- VISUALIZACIÓN ---
    function actualizarPreview() {
        const papel = document.getElementById('Tipo_Papel').value;
        const orientacion = document.getElementById('Orientacion').value;
        const header = document.getElementById('Cabecera_Texto').value;
        const footer = document.getElementById('Pie_Pagina_Texto').value;
        const logo = document.getElementById('Logo_Base64').value;

        const hoja = document.getElementById('hoja_papel');
        
        hoja.className = 'paper'; 
        hoja.classList.add('p-' + papel.toLowerCase());
        if(orientacion === 'Landscape') hoja.classList.add('landscape');

        document.getElementById('header_render').innerText = header || 'NOMBRE EMPRESA\nRFC: XAXX010101000\nDIRECCIÓN...';
        document.getElementById('footer_render').innerText = footer || 'GRACIAS POR SU COMPRA\nWifi: Clave123';

        const imgRender = document.getElementById('logo_render');
        if(logo) {
            imgRender.src = logo;
            imgRender.style.display = 'block';
        } else {
            imgRender.style.display = 'none';
        }
    }

    // --- IMAGEN ---
    function convertirLogo() {
        const input = document.getElementById('inputLogo');
        if (input.files && input.files[0]) {
            if(input.files[0].size > 500000) {
                Swal.fire('Imagen muy grande', 'Usa un logo menor a 500KB.', 'warning');
                input.value = '';
                return;
            }
            var reader = new FileReader();
            reader.onload = function (e) {
                const base64 = e.target.result;
                document.getElementById('Logo_Base64').value = base64;
                mostrarMiniaturaLogo(base64);
                actualizarPreview();
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function mostrarMiniaturaLogo(base64) {
        const img = document.getElementById('img_preview_mini');
        img.src = base64;
        img.style.display = 'block';
        document.getElementById('txt_no_logo').style.display = 'none';
        document.getElementById('btn_borrar_logo').style.display = 'block';
    }

    function borrarLogo() {
        document.getElementById('inputLogo').value = '';
        document.getElementById('Logo_Base64').value = '';
        document.getElementById('img_preview_mini').style.display = 'none';
        document.getElementById('txt_no_logo').style.display = 'block';
        document.getElementById('btn_borrar_logo').style.display = 'none';
        actualizarPreview();
    }
</script>