<?php
/* --------------------------------------------------------------------------------
   MÓDULO: REPORTE DE COMPRAS INTELIGENTE (PARETO ABC + VENTANA DE IMPRESIÓN)
   --------------------------------------------------------------------------------
*/
error_reporting(E_ALL);
ini_set('display_errors', 0);

if (session_status() === PHP_SESSION_NONE) { session_start(); }

// 1. SEGURIDAD
if (!isset($_SESSION['Acceso']) || $_SESSION['Acceso'] !== 'AccesoSiqueSi') {
    die('<div class="alert alert-danger">Acceso Denegado.</div>');
}

// 2. CONTEXTO DE BASE DE DATOS
$nombre_bd = "MS_Datos"; 
$prefijo   =  $IDUg;
	echo "<script> console.log('ID Usuario: $prefijo'); </script>";

$APP_CONFIG = [
    'db'     => $nombre_bd,
    'tables' => [
        'inv'    => $prefijo . "-Productos_Inventario",
        'prod'   => $prefijo . "-Productos_Catalogo",
        'ventas' => $prefijo . "-Ventas_Detalle",
        'config' => $prefijo . "-Configuracion_Impresoras"
    ]
];
?>

<style>
    /* Colores para la interfaz principal */
    .txt-prioridad-A { color: #d32f2f !important; font-weight: 700; } /* Rojo */
    .txt-prioridad-B { color: #f57c00 !important; font-weight: 700; } /* Naranja */
    .txt-prioridad-C { color: #1976d2 !important; font-weight: 700; } /* Azul */
    
    .card-pro { border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.08); }
    
    /* Estilo del Modal de Impresión (Estilo Historial) */
    .preview-container { background: #525659; padding: 30px; display: flex; justify-content: center; min-height: 500px; }
    .paper-sheet { background: white; box-shadow: 0 0 20px rgba(0,0,0,0.4); padding: 20px; transition: all 0.3s; }
    .sheet-80mm { width: 80mm; font-family: 'Courier New', monospace; }
    .sheet-a4 { width: 210mm; min-height: 297mm; font-family: Arial, sans-serif; }

    .btn-print-big { background: linear-gradient(135deg, #232526 0%, #414345 100%); color: white; border: none; padding: 12px; border-radius: 8px; font-weight: bold; }
</style>

<div class="container-fluid p-4">
    <div class="row mb-4">
        <div class="col-md-8">
            <h3 class="font-weight-bold">Reposición de Inventario</h3>
            <p class="text-muted small">Los colores indican la prioridad de venta (Pareto): <span class="txt-prioridad-A">CLASE A</span>, <span class="txt-prioridad-B">CLASE B</span>, <span class="txt-prioridad-C">CLASE C</span>.</p>
        </div>
        <div class="col-md-4 text-right">
            <button class="btn btn-dark shadow" onclick="abrirModalImpresion()">
                <i class="fas fa-print mr-2"></i> PREPARAR ORDEN DE COMPRA
            </button>
        </div>
    </div>

    <div class="card card-pro">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>SKU / PRODUCTO</th>
                            <th class="text-center">STOCK ACTUAL</th>
                            <th class="text-center">STOCK MÁX.</th>
                            <th class="text-center bg-info text-white">CANTIDAD A PEDIR</th>
                            <th class="text-right pr-4">COSTO EST.</th>
                        </tr>
                    </thead>
                    <tbody id="tblFaltantesBody">
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalImpresion" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" style="max-width: 95%;">
        <div class="modal-content border-0">
            <div class="modal-header bg-dark text-white py-2">
                <h6 class="modal-title small">CENTRO DE IMPRESIÓN PROFESIONAL</h6>
                <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body p-0">
                <div class="row no-gutters">
                    <div class="col-md-3 bg-white p-4">
                        <label class="font-weight-bold small">PERFIL DE IMPRESORA</label>
                        <select id="selImpresora" class="form-control mb-4" onchange="actualizarVistaPrevia()"></select>
                        
                        <div class="alert alert-info small border-0 shadow-sm">
                            <i class="fas fa-info-circle mr-1"></i> Se generará una <b>ventana hija</b> limpia para evitar contaminación visual al imprimir.
                        </div>

                        <button class="btn btn-print-big btn-block" onclick="imprimirEnVentanaNueva()">
                            <i class="fas fa-external-link-alt mr-2"></i> ABRIR E IMPRIMIR
                        </button>
                    </div>
                    <div class="col-md-9 preview-container">
                        <div id="areaImpresion" class="paper-sheet sheet-a4">
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
const DB_CONFIG = <?php echo json_encode($APP_CONFIG); ?>;
let DATA_PEDIDO = [];
let CACHE_PERFILES = [];

document.addEventListener('DOMContentLoaded', () => {
    cargarDatos();
    cargarPerfiles();
});

async function cargarDatos() {
    const tbody = document.getElementById('tblFaltantesBody');
    tbody.innerHTML = '<tr><td colspan="5" class="text-center py-5"><div class="spinner-border text-primary"></div></td></tr>';

    const sqlFaltantes = `
        SELECT i.sku, c.nombre, c.unidad_medida, i.existencia, i.stock_minimo, i.stock_maximo, i.costo_promedio
        FROM \`${DB_CONFIG.db}\`.\`${DB_CONFIG.tables.inv}\` i
        JOIN \`${DB_CONFIG.db}\`.\`${DB_CONFIG.tables.prod}\` c ON i.sku = c.sku
        WHERE i.existencia <= i.stock_minimo AND c.activo = 1
    `;
    const sqlPareto = `SELECT SKU, SUM(Cantidad) as v FROM \`${DB_CONFIG.db}\`.\`${DB_CONFIG.tables.ventas}\` GROUP BY SKU ORDER BY v DESC`;

    const [rF, rP] = await Promise.all([ajaxSelect(sqlFaltantes), ajaxSelect(sqlPareto)]);

    // Procesar Pareto para colores
    let pMap = {};
    if(rP.data) {
        let total = rP.data.reduce((acc, curr) => acc + parseFloat(curr.v), 0);
        let acum = 0;
        rP.data.forEach(p => {
            acum += (parseFloat(p.v) * 100 / total);
            pMap[p.SKU] = acum <= 80 ? 'A' : (acum <= 95 ? 'B' : 'C');
        });
    }

    DATA_PEDIDO = (rF.data || []).map(f => {
        const clase = pMap[f.sku] || 'C';
        const a_pedir = parseFloat(f.stock_maximo) - parseFloat(f.existencia);
        return { ...f, clase, a_pedir, total: a_pedir * f.costo_promedio };
    }).filter(x => x.a_pedir > 0);

    // Ordenar A-B-C
    DATA_PEDIDO.sort((a,b) => a.clase.localeCompare(b.clase));

    tbody.innerHTML = '';
    DATA_PEDIDO.forEach(row => {
        const colorClase = `txt-prioridad-${row.clase}`;
        tbody.innerHTML += `
            <tr>
                <td>
                    <span class="${colorClase}" style="font-size:1.1rem;">${row.sku}</span><br>
                    <span class="text-uppercase small font-weight-bold">${row.nombre}</span>
                </td>
                <td class="text-center font-weight-bold text-muted">${parseFloat(row.existencia)}</td>
                <td class="text-center font-weight-bold text-muted">${parseFloat(row.stock_maximo)}</td>
                <td class="text-center">
                    <span class="badge badge-info px-3 py-2" style="font-size:1rem;">${row.a_pedir} ${row.unidad_medida}</span>
                </td>
                <td class="text-right pr-4 font-weight-bold">$${row.total.toFixed(2)}</td>
            </tr>`;
    });
}

async function cargarPerfiles() {
    const res = await ajaxSelect(`SELECT * FROM \`${DB_CONFIG.db}\`.\`${DB_CONFIG.tables.config}\` WHERE Activo = 1`);
    CACHE_PERFILES = res.data || [];
    const sel = document.getElementById('selImpresora');
    sel.innerHTML = CACHE_PERFILES.map((p, i) => `<option value="${i}">${p.Nombre_Perfil}</option>`).join('') || '<option value="-1">Default 80mm</option>';
}

function abrirModalImpresion() {
    $('#modalImpresion').modal('show');
    setTimeout(actualizarVistaPrevia, 300);
}

function actualizarVistaPrevia() {
    const area = document.getElementById('areaImpresion');
    const idx = document.getElementById('selImpresora').value;
    const perfil = CACHE_PERFILES[idx] || { Tipo_Papel: 'A4', Nombre_Perfil: 'ORDEN' };

    area.className = 'paper-sheet ' + (perfil.Tipo_Papel.includes('A4') ? 'sheet-a4' : 'sheet-80mm');
    
    let totalG = 0;
    let rows = DATA_PEDIDO.map(item => {
        totalG += item.total;
        return `
        <tr>
            <td style="border-bottom:1px solid #eee; padding:8px;">${item.sku}</td>
            <td style="border-bottom:1px solid #eee; padding:8px;"><b>${item.nombre}</b></td>
            <td align="center" style="border-bottom:1px solid #eee; font-size:1.2em;"><b>${item.a_pedir}</b></td>
            <td align="center" style="border-bottom:1px solid #eee;">${item.unidad_medida}</td>
        </tr>`;
    }).join('');

    area.innerHTML = `
        <div style="text-align:center; margin-bottom:20px;">
            ${perfil.Logo_Base64 ? `<img src="${perfil.Logo_Base64}" height="60"><br>` : ''}
            <h2 style="margin:0;">ORDEN DE SURTIDO</h2>
            <p>Fecha: ${new Date().toLocaleDateString()}</p>
        </div>
        <table width="100%" cellspacing="0" style="font-size:12px;">
            <thead style="background:#333; color:#fff;">
                <tr><th align="left" style="padding:10px;">SKU</th><th align="left">DESCRIPCIÓN</th><th align="center">CANTIDAD</th><th align="center">UNIDAD</th></tr>
            </thead>
            <tbody>${rows}</tbody>
        </table>
        <div style="text-align:right; margin-top:20px;"><h3>Total Estimado: $${totalG.toFixed(2)}</h3></div>
    `;
}

function imprimirEnVentanaNueva() {
    const contenido = document.getElementById('areaImpresion').innerHTML;
    const claseHoja = document.getElementById('areaImpresion').className;
    
    // Abrir ventana hija
    const ventana = window.open('', 'PRINT', 'height=800,width=1000');
    
    ventana.document.write(`
        <html>
            <head>
                <title>Imprimir Orden de Compra</title>
                <style>
                    body { background: #fff; margin: 0; padding: 20px; font-family: Arial, sans-serif; }
                    .paper-sheet { width: 100%; box-shadow: none !important; }
                    .sheet-80mm { width: 80mm; font-family: 'Courier New', monospace; }
                    @media print { body { padding: 0; } }
                </style>
            </head>
            <body class="${claseHoja}">
                ${contenido}
                <script>
                    setTimeout(() => { window.print(); window.close(); }, 500);
                <\/script>
            </body>
        </html>
    `);
    ventana.document.close();
}

async function ajaxSelect(sql) {
    const fd = new FormData(); fd.append('sql', sql); fd.append('db', DB_CONFIG.db);
    try { return await (await fetch('../librerias/AJAX/Select.php', { method: 'POST', body: fd })).json(); } catch (e) { return { data: [] }; }
}
</script>